/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.elements;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import de.neemann.digital.XStreamValid;
import de.neemann.digital.analyse.expression.format.FormatToExpression;
import de.neemann.digital.core.IntFormat;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.Observer;
import de.neemann.digital.core.SyncAccess;
import de.neemann.digital.core.arithmetic.BarrelShifterMode;
import de.neemann.digital.core.arithmetic.LeftRightFormat;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.element.Rotation;
import de.neemann.digital.core.extern.Application;
import de.neemann.digital.core.io.In;
import de.neemann.digital.core.io.InValue;
import de.neemann.digital.core.io.Out;
import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.core.memory.DataFieldConverter;
import de.neemann.digital.core.memory.rom.ROMManager;
import de.neemann.digital.core.memory.rom.ROMManagerFile;
import de.neemann.digital.core.wiring.AsyncSeq;
import de.neemann.digital.core.wiring.Clock;
import de.neemann.digital.draw.elements.DotCreator;
import de.neemann.digital.draw.elements.Movable;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.elements.Wire;
import de.neemann.digital.draw.elements.WireConsistencyChecker;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.PolygonConverter;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.library.GenericInitCode;
import de.neemann.digital.draw.model.InverterConfig;
import de.neemann.digital.draw.shapes.CustomCircuitShapeType;
import de.neemann.digital.draw.shapes.Drawable;
import de.neemann.digital.draw.shapes.Shape;
import de.neemann.digital.draw.shapes.ShapeFactory;
import de.neemann.digital.draw.shapes.custom.CustomShapeDescription;
import de.neemann.digital.gui.components.TransformHolder;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.TestCaseDescription;
import de.neemann.digital.testing.TestCaseElement;
import de.neemann.digital.undo.Copyable;
import de.neemann.gui.language.Language;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Circuit
implements Copyable<Circuit> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Circuit.class);
    private static final Set<Drawable> EMPTY_SET = Collections.emptySet();
    private int version = 2;
    private ElementAttributes attributes;
    private final ArrayList<VisualElement> visualElements = new ArrayList();
    private ArrayList<Wire> wires = new ArrayList();
    private List<String> measurementOrdering;
    private transient boolean dotsPresent = false;
    private transient File origin;

    public static XStream getxStream() {
        XStreamValid xStream = new XStreamValid();
        xStream.alias("attributes", ElementAttributes.class);
        xStream.alias("visualElement", VisualElement.class);
        xStream.alias("wire", Wire.class);
        xStream.alias("circuit", Circuit.class);
        xStream.alias("intFormat", IntFormat.class);
        xStream.alias("exprFormat", FormatToExpression.class);
        xStream.alias("barrelShifterMode", BarrelShifterMode.class);
        xStream.alias("direction", LeftRightFormat.class);
        xStream.alias("rotation", Rotation.class);
        xStream.aliasAttribute(Rotation.class, "rotation", "rotation");
        xStream.alias("language", Language.class);
        xStream.aliasAttribute(Language.class, "name", "name");
        xStream.alias("vector", Vector.class);
        xStream.aliasAttribute(Vector.class, "x", "x");
        xStream.aliasAttribute(Vector.class, "y", "y");
        xStream.alias("value", InValue.class);
        xStream.aliasAttribute(InValue.class, "value", "v");
        xStream.aliasAttribute(InValue.class, "highZ", "z");
        xStream.addImplicitCollection(ElementAttributes.class, "attributes");
        xStream.alias("data", DataField.class);
        xStream.registerConverter(new DataFieldConverter());
        xStream.alias("testData", TestCaseDescription.class);
        xStream.alias("inverterConfig", InverterConfig.class);
        xStream.addImplicitCollection(InverterConfig.class, "inputs");
        xStream.alias("storedRoms", ROMManager.class);
        xStream.addImplicitCollection(ROMManager.class, "roms");
        xStream.alias("romList", ROMManagerFile.class);
        xStream.alias("romFile", ROMManagerFile.RomContainerFile.class);
        xStream.alias("romData", ROMManagerFile.RomContainerDataField.class);
        xStream.alias("appType", Application.Type.class);
        xStream.ignoreUnknownElements();
        xStream.alias("shape", CustomShapeDescription.class);
        xStream.alias("pin", CustomShapeDescription.Pin.class);
        xStream.alias("circle", CustomShapeDescription.CircleHolder.class);
        xStream.alias("line", CustomShapeDescription.LineHolder.class);
        xStream.alias("poly", CustomShapeDescription.PolygonHolder.class);
        xStream.alias("text", CustomShapeDescription.TextHolder.class);
        xStream.alias("polygon", Polygon.class);
        xStream.alias("shapeType", CustomCircuitShapeType.class);
        xStream.alias("transform", TransformHolder.class);
        xStream.registerConverter(new PolygonConverter());
        return xStream;
    }

    public static Circuit loadCircuit(File filename, ShapeFactory shapeFactory) throws IOException {
        LOGGER.debug("load " + filename);
        Circuit circuit = Circuit.loadCircuit(new FileInputStream(filename), shapeFactory);
        circuit.origin = filename;
        return circuit;
    }

    public static Circuit loadCircuit(InputStream in, ShapeFactory shapeFactory) throws IOException {
        LOGGER.debug("load stream");
        try {
            XStream xStream = Circuit.getxStream();
            Circuit circuit = (Circuit)xStream.fromXML(in);
            for (VisualElement ve : circuit.getElements()) {
                ve.setShapeFactory(shapeFactory);
            }
            if (circuit.version == 0) {
                for (Wire w : circuit.getWires()) {
                    w.p1 = w.p1.mul(2);
                    w.p2 = w.p2.mul(2);
                }
                for (VisualElement e : circuit.getElements()) {
                    e.setPos(e.getPos().mul(2));
                }
                circuit.version = 1;
            }
            if (circuit.version < 2) {
                ROMManagerFile rm = circuit.getAttributes().get(Keys.ROMMANAGER);
                if (rm instanceof ROMManager) {
                    circuit.getAttributes().set(Keys.ROMMANAGER, new ROMManagerFile((ROMManager)((Object)rm)));
                }
                circuit.version = 2;
            }
            Circuit circuit2 = circuit;
            return circuit2;
        }
        catch (RuntimeException e) {
            throw new IOException(Lang.get("err_invalidFileFormat", new Object[0]), e);
        }
        finally {
            in.close();
        }
    }

    public void save(File filename) throws IOException {
        this.save(new FileOutputStream(filename));
    }

    public void save(OutputStream out) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStreamWriter w = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
            XStream xStream = Circuit.getxStream();
            w.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            xStream.marshal(this, new PrettyPrintWriter(w));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Circuit() {
    }

    private Circuit(Circuit original) {
        this();
        for (VisualElement ve : original.visualElements) {
            this.visualElements.add(new VisualElement(ve));
        }
        for (Wire w : original.wires) {
            this.wires.add(new Wire(w));
        }
        if (original.attributes != null) {
            this.attributes = new ElementAttributes(original.attributes);
        }
        this.measurementOrdering = new ArrayList<String>();
        if (original.measurementOrdering != null) {
            this.measurementOrdering.addAll(original.measurementOrdering);
        }
        this.origin = original.origin;
        this.version = 2;
    }

    @Override
    public Circuit createDeepCopy() {
        return new Circuit(this);
    }

    public Circuit createShallowCopy() {
        Circuit circuit = new Circuit();
        if (this.attributes != null) {
            circuit.attributes = new ElementAttributes(this.attributes);
        }
        circuit.wires.addAll(this.wires);
        circuit.visualElements.addAll(this.visualElements);
        circuit.origin = this.origin;
        return circuit;
    }

    public ElementAttributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ElementAttributes();
        }
        return this.attributes;
    }

    public void drawTo(Graphic graphic) {
        this.drawTo(graphic, EMPTY_SET, null, SyncAccess.NOSYNC);
    }

    public void drawTo(Graphic graphic, boolean presentingMode) {
        this.drawTo(graphic, EMPTY_SET, null, SyncAccess.NOSYNC, presentingMode);
    }

    public void drawTo(Graphic graphic, Collection<Drawable> highLighted, Style highlight, SyncAccess modelSync) {
        this.drawTo(graphic, highLighted, highlight, modelSync, false);
    }

    public void drawTo(Graphic graphic, Collection<Drawable> highLighted, Style highlight, SyncAccess modelSync, boolean presentationMode) {
        if (!this.dotsPresent) {
            new DotCreator(this.wires).applyDots();
            this.dotsPresent = true;
        }
        modelSync.read(() -> {
            for (Wire w : this.wires) {
                w.readObservableValues();
            }
            for (VisualElement p : this.visualElements) {
                p.getShape().readObservableValues();
            }
        });
        graphic.openGroup();
        for (Wire w : this.wires) {
            w.drawTo(graphic, highLighted.contains(w) ? highlight : null);
        }
        graphic.closeGroup();
        for (VisualElement ve : this.visualElements) {
            if (presentationMode && this.hideInPresentationMode(ve)) continue;
            graphic.openGroup();
            ve.drawTo(graphic, highLighted.contains(ve) ? highlight : null);
            graphic.closeGroup();
        }
    }

    private boolean hideInPresentationMode(VisualElement ve) {
        return ve.equalsDescription(TestCaseElement.DESCRIPTION) || ve.equalsDescription(GenericInitCode.DESCRIPTION) || ve.equalsDescription(AsyncSeq.DESCRIPTION);
    }

    public Circuit add(VisualElement visualElement) {
        this.visualElements.add(visualElement);
        return this;
    }

    public Circuit add(Wire newWire) {
        if (newWire.p1.equals(newWire.p2)) {
            return null;
        }
        this.wires.add(newWire);
        WireConsistencyChecker checker = new WireConsistencyChecker(this.wires);
        this.wires = checker.check();
        this.dotsPresent = false;
        return this;
    }

    public Circuit add(ArrayList<Wire> newWires) {
        this.wires.addAll(newWires);
        WireConsistencyChecker checker = new WireConsistencyChecker(this.wires);
        this.wires = checker.check();
        this.dotsPresent = false;
        return this;
    }

    public void elementsMoved() {
        WireConsistencyChecker checker = new WireConsistencyChecker(this.wires);
        this.wires = checker.check();
        this.dotsPresent = false;
    }

    public ArrayList<VisualElement> getElements() {
        return this.visualElements;
    }

    public List<VisualElement> getElements(ElementFilter filter) {
        ArrayList<VisualElement> found = new ArrayList<VisualElement>();
        for (VisualElement v : this.visualElements) {
            if (!filter.accept(v)) continue;
            found.add(v);
        }
        return found;
    }

    public List<TestCase> getTestCases() {
        ArrayList<TestCase> tc = new ArrayList<TestCase>();
        for (VisualElement ve : this.getElements(v -> v.equalsDescription(TestCaseElement.DESCRIPTION) && v.getElementAttributes().get(Keys.ENABLED) != false)) {
            tc.add(new TestCase(ve));
        }
        return tc;
    }

    public ArrayList<Movable> getElementsToMove(Vector min, Vector max) {
        ArrayList<Movable> m = new ArrayList<Movable>();
        for (VisualElement vp : this.visualElements) {
            if (!vp.matches(min, max)) continue;
            m.add(vp);
        }
        for (Wire w : this.wires) {
            if (w.p1.inside(min, max)) {
                m.add(w.getMovableP1());
            }
            if (!w.p2.inside(min, max)) continue;
            m.add(w.getMovableP2());
        }
        if (m.isEmpty()) {
            return null;
        }
        return m;
    }

    public ArrayList<Drawable> getElementsToHighlight(Vector min, Vector max) {
        ArrayList<Drawable> m = new ArrayList<Drawable>();
        for (VisualElement vp : this.visualElements) {
            if (!vp.matches(min, max)) continue;
            m.add(vp);
        }
        for (Wire w : this.wires) {
            if (!w.p1.inside(min, max) && !w.p2.inside(min, max)) continue;
            m.add(w);
        }
        if (m.isEmpty()) {
            return null;
        }
        return m;
    }

    public ArrayList<Movable> copyElementsToMove(Vector min, Vector max, ShapeFactory shapeFactory) {
        ArrayList<Movable> m = new ArrayList<Movable>();
        for (VisualElement vp : this.visualElements) {
            if (!vp.matches(min, max)) continue;
            m.add(new VisualElement(vp).setShapeFactory(shapeFactory));
        }
        for (Wire w : this.wires) {
            if (!w.p1.inside(min, max) || !w.p2.inside(min, max)) continue;
            m.add(new Wire(w));
        }
        if (m.isEmpty()) {
            return null;
        }
        return m;
    }

    public RectContainer copyElementsInRect(Vector min, Vector max, ShapeFactory shapeFactory) {
        ArrayList<Drawable> d = new ArrayList<Drawable>();
        ArrayList<Movable> m = new ArrayList<Movable>();
        for (VisualElement vp : this.visualElements) {
            if (!vp.matches(min, max)) continue;
            VisualElement ve = new VisualElement(vp).setShapeFactory(shapeFactory);
            m.add(ve);
            d.add(ve);
        }
        for (Wire w : this.wires) {
            boolean p1Inside = w.p1.inside(min, max);
            boolean p2Inside = w.p2.inside(min, max);
            if (!p1Inside && !p2Inside) continue;
            Wire ww = new Wire(w);
            d.add(ww);
            if (p1Inside) {
                m.add(ww.getMovableP1());
            }
            if (!p2Inside) continue;
            m.add(ww.getMovableP2());
        }
        if (m.isEmpty() && d.isEmpty()) {
            return null;
        }
        return new RectContainer(d, m);
    }

    public void delete(Vector min, Vector max) {
        Iterator<VisualElement> veIt = this.visualElements.iterator();
        while (veIt.hasNext()) {
            if (!veIt.next().matches(min, max)) continue;
            veIt.remove();
        }
        boolean wireDeleted = false;
        Iterator<Wire> wIt = this.wires.iterator();
        while (wIt.hasNext()) {
            Wire w = wIt.next();
            if (!w.p1.inside(min, max) && !w.p2.inside(min, max)) continue;
            wIt.remove();
            wireDeleted = true;
        }
        if (wireDeleted) {
            WireConsistencyChecker checker = new WireConsistencyChecker(this.wires);
            this.wires = checker.check();
        }
        this.dotsPresent = false;
    }

    public void delete(VisualElement partToDelete) {
        this.visualElements.remove(partToDelete);
    }

    public void delete(Wire wireToDelete) {
        if (this.wires.remove(wireToDelete)) {
            WireConsistencyChecker checker = new WireConsistencyChecker(this.wires);
            this.wires = checker.check();
            this.dotsPresent = false;
        }
    }

    public VisualElement getElementAt(Vector pos) {
        return this.getElementAt(pos, false);
    }

    public VisualElement getElementAt(Vector pos, boolean includeText) {
        for (VisualElement element : this.visualElements) {
            if (!element.matches(pos, includeText)) continue;
            return element;
        }
        return null;
    }

    public List<VisualElement> getElementListAt(Vector pos, boolean includeText) {
        ArrayList<VisualElement> list = new ArrayList<VisualElement>();
        for (VisualElement element : this.visualElements) {
            if (!element.matches(pos, includeText)) continue;
            list.add(element);
        }
        return list;
    }

    public boolean isPinPos(Vector pos) {
        VisualElement el = this.getElementAt(pos);
        if (el == null) {
            return false;
        }
        return el.isPinPos(pos);
    }

    public ArrayList<Wire> getWires() {
        return this.wires;
    }

    public boolean isWireAt(Vector pos) {
        for (Wire w : this.wires) {
            if (!w.isPosOnWire(pos)) continue;
            return true;
        }
        return false;
    }

    public Wire getWireAt(Vector pos, int radius) {
        float minDist = 0.0f;
        Wire best = null;
        for (Wire w : this.wires) {
            if (!w.contains(pos, radius)) continue;
            float d = w.distance(pos);
            if (best != null && !(d < minDist)) continue;
            minDist = d;
            best = w;
        }
        return best;
    }

    public void clearState() {
        for (VisualElement vp : this.visualElements) {
            vp.setState(null);
        }
        for (Wire w : this.wires) {
            w.setValue(null);
        }
    }

    public PinDescription[] getInputNames() throws PinException {
        ArrayList<PinInfo> pinList = new ArrayList<PinInfo>();
        for (VisualElement ve : this.visualElements) {
            if (!ve.equalsDescription(In.DESCRIPTION) && !ve.equalsDescription(Clock.DESCRIPTION)) continue;
            ElementAttributes attr = ve.getElementAttributes();
            String name = attr.getLabel();
            if (name == null || name.length() == 0) {
                if (ve.equalsDescription(Clock.DESCRIPTION)) {
                    throw new PinException(Lang.get("err_clockWithoutName", new Object[0]));
                }
                throw new PinException(Lang.get("err_pinWithoutName", new Object[0]));
            }
            PinInfo pin = ve.equalsDescription(Clock.DESCRIPTION) ? PinInfo.input(name, Lang.get("elem_Clock", new Object[0])).setClock() : PinInfo.input(name, Lang.evalMultilingualContent(attr.get(Keys.DESCRIPTION)));
            pinList.add(pin.setPinNumber(attr.get(Keys.PINNUMBER)));
        }
        return pinList.toArray(new PinDescription[0]);
    }

    public ObservableValues getOutputNames() throws PinException {
        ArrayList<ObservableValue> pinList = new ArrayList<ObservableValue>();
        for (VisualElement ve : this.visualElements) {
            if (!ve.equalsDescription(Out.DESCRIPTION)) continue;
            ElementAttributes attr = ve.getElementAttributes();
            String name = attr.getLabel();
            if (name == null || name.length() == 0) {
                throw new PinException(Lang.get("err_pinWithoutName", new Object[0]));
            }
            String descr = Lang.evalMultilingualContent(attr.get(Keys.DESCRIPTION));
            pinList.add(new ObservableValue(name, 0){

                @Override
                public long getValue() {
                    throw new RuntimeException("invalid call!");
                }

                @Override
                public ObservableValue addObserverToValue(Observer observer) {
                    throw new RuntimeException("invalid call!");
                }

                @Override
                public int getBits() {
                    throw new RuntimeException("invalid call!");
                }
            }.setDescription(descr).setPinNumber(attr.get(Keys.PINNUMBER)));
        }
        return new ObservableValues((Collection<ObservableValue>)pinList);
    }

    public ArrayList<VisualElement> findElements(String search) {
        search = search.toLowerCase();
        ArrayList<VisualElement> found = new ArrayList<VisualElement>();
        for (VisualElement ve : this.visualElements) {
            boolean match;
            ElementAttributes attr = ve.getElementAttributes();
            boolean bl = match = attr.getLabel().toLowerCase().contains(search) || attr.get(Keys.DESCRIPTION).toLowerCase().contains(search) || attr.get(Keys.NETNAME).toLowerCase().contains(search) || attr.get(Keys.PINNUMBER).toLowerCase().contains(search);
            if (!match) {
                Shape shape = ve.getShape();
                for (Pin p : shape.getPins()) {
                    if (!p.getName().toLowerCase().contains(search)) continue;
                    match = true;
                    break;
                }
            }
            if (!match) continue;
            found.add(ve);
        }
        return found;
    }

    public List<String> getMeasurementOrdering() {
        return this.measurementOrdering;
    }

    public void setMeasurementOrdering(List<String> measurementOrdering) {
        this.measurementOrdering = measurementOrdering;
    }

    public File getOrigin() {
        return this.origin;
    }

    public void setOrigin(File filename) {
        this.origin = filename;
    }

    public static interface ElementFilter {
        public boolean accept(VisualElement var1);
    }

    public static final class RectContainer {
        private final ArrayList<Drawable> d;
        private final ArrayList<Movable> m;

        private RectContainer(ArrayList<Drawable> d, ArrayList<Movable> m) {
            this.d = d;
            this.m = m;
        }

        public ArrayList<Drawable> getDrawables() {
            return this.d;
        }

        public ArrayList<Movable> getMovables() {
            return this.m;
        }
    }

    public static final class TestCase
    implements Comparable<TestCase> {
        private final String label;
        private final TestCaseDescription testCaseDescription;
        private final boolean hasGenericCode;
        private final VisualElement visualElement;

        private TestCase(VisualElement visualElement) {
            this.visualElement = visualElement;
            ElementAttributes attr = visualElement.getElementAttributes();
            this.label = attr.getLabel();
            this.testCaseDescription = attr.get(Keys.TESTDATA);
            this.hasGenericCode = !attr.get(Keys.GENERIC).isEmpty();
        }

        public String getLabel() {
            return this.label;
        }

        public TestCaseDescription getTestCaseDescription() {
            return this.testCaseDescription;
        }

        public boolean hasGenericCode() {
            return this.hasGenericCode;
        }

        public VisualElement getVisualElement() {
            return this.visualElement;
        }

        @Override
        public int compareTo(TestCase o) {
            return this.label.compareTo(o.label);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestCase testCase = (TestCase)o;
            return this.label.equals(testCase.label);
        }

        public int hashCode() {
            return this.label.hashCode();
        }
    }
}

