/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.elements;

import de.neemann.digital.draw.elements.Wire;
import de.neemann.digital.draw.graphics.Vector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DotCreator {
    private final ArrayList<Dot> dots;
    private final ArrayList<Wire> wires;
    private HashMap<Vector, Dot> map;

    public DotCreator(ArrayList<Wire> wires) {
        this.wires = wires;
        this.map = new HashMap();
        for (Wire wire : wires) {
            this.inc(wire.p1, wire);
            this.inc(wire.p2, wire);
        }
        this.dots = new ArrayList();
        for (Map.Entry entry : this.map.entrySet()) {
            if (((Dot)entry.getValue()).counter <= 2) continue;
            this.dots.add((Dot)entry.getValue());
        }
        this.map = null;
    }

    private void inc(Vector vector, Wire w) {
        Dot c = this.map.get(vector);
        if (c == null) {
            c = new Dot(vector, w);
            this.map.put(vector, c);
        }
        c.inc();
    }

    public void applyDots() {
        for (Wire w : this.wires) {
            w.noDot();
        }
        for (Dot d : this.dots) {
            d.setDot();
        }
    }

    private static class Dot {
        private final Vector vector;
        private final Wire w;
        private int counter;

        Dot(Vector vector, Wire w) {
            this.vector = vector;
            this.w = w;
        }

        private void inc() {
            ++this.counter;
        }

        Vector getVector() {
            return this.vector;
        }

        void setDot() {
            this.w.setDot(this.vector);
        }
    }
}

