/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.gif;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.ModelEvent;
import de.neemann.digital.core.ModelEventType;
import de.neemann.digital.core.ModelStateObserverTyped;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.gif.GifSequenceWriter;
import de.neemann.digital.draw.graphics.GraphicMinMax;
import de.neemann.digital.draw.graphics.GraphicsImage;
import de.neemann.digital.draw.graphics.linemerger.GraphicLineCollector;
import de.neemann.digital.draw.graphics.linemerger.GraphicSkipLines;
import de.neemann.digital.gui.ModelModifier;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.ErrorMessage;
import de.neemann.gui.Screen;
import de.neemann.gui.ToolTipAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GifExporter
extends JDialog
implements ModelStateObserverTyped,
ModelModifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(GifExporter.class);
    private final Circuit circuit;
    private final GraphicMinMax minMax;
    private final JLabel frameLabel;
    private int frames;
    private FileImageOutputStream output;
    private GifSequenceWriter writer;
    private boolean closed = false;

    public GifExporter(JFrame parent, Circuit circuit, int delayMs, File file) throws IOException {
        super(parent, Lang.get("msg_gifExport", new Object[0]), false);
        this.setDefaultCloseOperation(2);
        this.frameLabel = new JLabel(Lang.get("msg_framesWritten_N", this.frames));
        this.frameLabel.setFont(Screen.getInstance().getFont(1.5f));
        this.frameLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(this.frameLabel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                GifExporter.this.close();
            }
        });
        this.getContentPane().add((Component)new ToolTipAction(Lang.get("btn_gifComplete", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GifExporter.this.close();
            }
        }.setToolTip(Lang.get("btn_gifComplete_tt", new Object[0])).createJButton(), "South");
        this.circuit = circuit;
        this.minMax = new GraphicMinMax();
        circuit.drawTo(this.minMax);
        LOGGER.debug("open GIF file");
        this.output = new FileImageOutputStream(file);
        this.writer = new GifSequenceWriter(this.output, 2, delayMs, true);
        this.pack();
        this.setLocation(parent.getLocation());
    }

    private void close() {
        if (!this.closed) {
            try {
                this.writer.close();
                this.output.close();
                LOGGER.debug("closed GIF file");
                this.closed = true;
            }
            catch (IOException e) {
                SwingUtilities.invokeLater(new ErrorMessage(Lang.get("msg_errorWritingGif", new Object[0])).addCause(e));
            }
        }
        this.dispose();
    }

    @Override
    public void preInit(Model model) throws NodeException {
        SwingUtilities.invokeLater(() -> this.setVisible(true));
        model.addObserver(this);
    }

    @Override
    public void handleEvent(ModelEvent event) {
        if (event == ModelEvent.STEP) {
            this.writeImage();
        }
    }

    @Override
    public ModelEventType[] getEvents() {
        return new ModelEventType[]{ModelEventType.STEP};
    }

    private void writeImage() {
        if (!this.closed) {
            try {
                this.writer.writeToSequence(this.createBufferedImage());
            }
            catch (IOException e) {
                SwingUtilities.invokeLater(new ErrorMessage(Lang.get("msg_errorWritingGif", new Object[0])).addCause(e));
            }
            ++this.frames;
            this.frameLabel.setText(Lang.get("msg_framesWritten_N", this.frames));
            LOGGER.debug("frame written to GIF file");
        }
    }

    private BufferedImage createBufferedImage() throws IOException {
        GraphicsImage gri = new GraphicsImage(null, "gif", 1.0f);
        gri.setBoundingBox(this.minMax.getMin(), this.minMax.getMax());
        BufferedImage bi = gri.getBufferedImage();
        Graphics gr = bi.getGraphics();
        gr.setColor(Color.WHITE);
        gr.fillRect(0, 0, bi.getWidth(), bi.getHeight());
        GraphicLineCollector glc = new GraphicLineCollector();
        this.circuit.drawTo(glc);
        glc.drawTo(gri);
        this.circuit.drawTo(new GraphicSkipLines(gri));
        return gri.getBufferedImage();
    }
}

