/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics;

import de.neemann.digital.draw.graphics.TransformMatrix;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.graphics.VectorFloat;

public interface Transform {
    public static final Transform IDENTITY = new Transform(){

        @Override
        public Vector transform(Vector v) {
            return v;
        }

        @Override
        public VectorFloat transform(VectorFloat v) {
            return v;
        }

        @Override
        public TransformMatrix getMatrix() {
            return new TransformMatrix(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }

        @Override
        public Transform invert() {
            return IDENTITY;
        }
    };

    public static Transform mul(Transform t1, Transform t2) {
        TransformMatrix m1 = t1.getMatrix();
        TransformMatrix m2 = t2.getMatrix();
        return new TransformMatrix(m1.a * m2.a + m1.c * m2.b, m1.b * m2.a + m1.d * m2.b, m1.a * m2.c + m1.c * m2.d, m1.b * m2.c + m1.d * m2.d, m2.a * m1.x + m2.b * m1.y + m2.x, m2.c * m1.x + m2.d * m1.y + m2.y);
    }

    public Vector transform(Vector var1);

    public VectorFloat transform(VectorFloat var1);

    public TransformMatrix getMatrix();

    default public Transform invert() {
        return this.getMatrix().invert();
    }
}

