/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics;

import de.neemann.digital.draw.graphics.Transform;
import de.neemann.digital.draw.graphics.TransformMatrix;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.graphics.VectorFloat;
import de.neemann.digital.draw.graphics.VectorInterface;

public class TransformTranslate
implements Transform {
    private final VectorInterface trans;

    public TransformTranslate(VectorInterface trans) {
        this.trans = trans;
    }

    public TransformTranslate(int x, int y) {
        this(new Vector(x, y));
    }

    public TransformTranslate(float x, float y) {
        this(new VectorFloat(x, y));
    }

    @Override
    public Vector transform(Vector v) {
        return v.add(this.trans.getX(), this.trans.getY());
    }

    @Override
    public VectorFloat transform(VectorFloat v) {
        return new VectorFloat(v.getXFloat() + this.trans.getXFloat(), v.getYFloat() + this.trans.getYFloat());
    }

    @Override
    public TransformMatrix getMatrix() {
        return new TransformMatrix(1.0f, 0.0f, 0.0f, 1.0f, this.trans.getXFloat(), this.trans.getYFloat());
    }

    @Override
    public Transform invert() {
        return new TransformTranslate(this.trans.div(-1));
    }
}

