/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics.text.formatter;

import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.draw.graphics.text.ParseException;
import de.neemann.digital.draw.graphics.text.Parser;
import de.neemann.digital.draw.graphics.text.text.Blank;
import de.neemann.digital.draw.graphics.text.text.Character;
import de.neemann.digital.draw.graphics.text.text.Decorate;
import de.neemann.digital.draw.graphics.text.text.ExpressionToText;
import de.neemann.digital.draw.graphics.text.text.Index;
import de.neemann.digital.draw.graphics.text.text.Sentence;
import de.neemann.digital.draw.graphics.text.text.Simple;
import de.neemann.digital.draw.graphics.text.text.Text;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public final class GraphicsFormatter {
    private GraphicsFormatter() {
    }

    public static Fragment createFragment(Graphics2D gr, String text) {
        return GraphicsFormatter.createFragment((Fragment fragment, Font font, String str) -> {
            FontMetrics metrics = gr.getFontMetrics(font);
            Rectangle2D rec = metrics.getStringBounds(str, gr);
            fragment.set((int)rec.getWidth(), (int)rec.getHeight(), metrics.getDescent());
        }, gr.getFont(), text);
    }

    public static Fragment createFragment(Graphics2D gr, Expression expression) throws FormatterException {
        return GraphicsFormatter.createFragment((Fragment fragment, Font font, String str) -> {
            FontMetrics metrics = gr.getFontMetrics(font);
            Rectangle2D rec = metrics.getStringBounds(str, gr);
            fragment.set((int)rec.getWidth(), (int)rec.getHeight(), metrics.getDescent());
        }, gr.getFont(), new ExpressionToText().createText(expression));
    }

    public static Fragment createFragment(FontSizer sizer, Font font, String text) {
        Fragment fragment;
        try {
            Text t = new Parser(text).parse();
            fragment = GraphicsFormatter.createFragment(sizer, font, t);
        }
        catch (ParseException | FormatterException e) {
            fragment = new TextFragment(sizer, font, text);
        }
        return fragment;
    }

    private static Fragment createFragment(FontSizer sizer, Font font, Text text) throws FormatterException {
        if (text instanceof Simple) {
            return new TextFragment(sizer, font, ((Simple)text).getText());
        }
        if (text instanceof Character) {
            return new TextFragment(sizer, font, "" + ((Character)text).getChar());
        }
        if (text instanceof Sentence) {
            Sentence s = (Sentence)text;
            SentenceFragment sf = new SentenceFragment();
            for (Text t : s) {
                if (t instanceof Blank) {
                    sf.pad(font.getSize() / 2);
                    continue;
                }
                Fragment f = GraphicsFormatter.createFragment(sizer, font, t);
                sf.add(f);
            }
            return sf.setUp();
        }
        if (text instanceof Index) {
            Index i = (Index)text;
            Fragment var = GraphicsFormatter.createFragment(sizer, font, i.getVar());
            Font f = font.deriveFont((float)font.getSize() / 1.4f);
            Fragment superScript = i.getSuperScript() == null ? null : GraphicsFormatter.createFragment(sizer, f, i.getSuperScript());
            Fragment subScript = i.getSubScript() == null ? null : GraphicsFormatter.createFragment(sizer, f, i.getSubScript());
            return new IndexFragment(var, superScript, subScript);
        }
        if (text instanceof Decorate) {
            Decorate d = (Decorate)text;
            switch (d.getStyle()) {
                case MATH: {
                    return GraphicsFormatter.createFragment(sizer, font.deriveFont(2), d.getContent());
                }
                case OVERLINE: {
                    return new OverlineFragment(GraphicsFormatter.createFragment(sizer, font, d.getContent()), font);
                }
            }
            return GraphicsFormatter.createFragment(sizer, font, d.getContent());
        }
        throw new FormatterException("unknown text element " + text.getClass().getSimpleName() + ", " + text);
    }

    public static interface FontSizer {
        public void setSizeTo(Fragment var1, Font var2, String var3);
    }

    public static final class FormatterException
    extends Exception {
        FormatterException(String message) {
            super(message);
        }
    }

    public static abstract class Fragment {
        protected int x;
        protected int y;
        protected int dx;
        protected int dy;
        protected int base;

        private Fragment() {
        }

        public void set(int dx, int dy, int base) {
            this.dx = dx;
            this.dy = dy;
            this.base = base;
        }

        void drawDirect(Graphics2D gr, int xOfs, int yOfs) {
        }

        public void draw(Graphics2D gr, int x, int y) {
            Font font = gr.getFont();
            Stroke stroke = gr.getStroke();
            this.drawDirect(gr, x, y);
            gr.setFont(font);
            gr.setStroke(stroke);
        }

        public int getWidth() {
            return this.dx;
        }

        public int getHeight() {
            return this.dy;
        }
    }

    private static final class IndexFragment
    extends Fragment {
        private final Fragment var;
        private final Fragment superScript;
        private final Fragment subScript;

        private IndexFragment(Fragment var, Fragment superScript, Fragment subScript) {
            this.var = var;
            this.superScript = superScript;
            this.subScript = subScript;
            this.dx = subScript != null && superScript != null ? var.dx + Math.max(subScript.dx, superScript.dx) : (subScript != null ? var.dx + subScript.dx : (superScript != null ? var.dx + superScript.dx : var.dx));
            this.dy = var.dy;
            int delta = var.dy / 3;
            int ofs = var.dy / 8;
            if (superScript != null) {
                superScript.x = var.dx;
                superScript.y = -delta - ofs;
                int h = -superScript.y + superScript.dy - superScript.base;
                if (h > var.dy - var.base) {
                    this.dy += h - (var.dy - var.base);
                }
            }
            if (subScript != null) {
                subScript.x = var.dx;
                subScript.y = delta - ofs;
                int b = subScript.y + subScript.base;
                if (b > var.base) {
                    this.base = b;
                    this.dy += b - var.base;
                } else {
                    this.base = var.base;
                }
            }
        }

        @Override
        void drawDirect(Graphics2D gr, int xOfs, int yOfs) {
            super.drawDirect(gr, xOfs, yOfs);
            this.var.drawDirect(gr, xOfs + this.x, yOfs + this.y);
            if (this.superScript != null) {
                this.superScript.drawDirect(gr, xOfs + this.x, yOfs + this.y);
            }
            if (this.subScript != null) {
                this.subScript.drawDirect(gr, xOfs + this.x, yOfs + this.y);
            }
        }
    }

    private static final class OverlineFragment
    extends Fragment {
        private final Fragment fragment;
        private final float fontSize;
        private final int border;
        private int dx1;
        private int dx2;

        private OverlineFragment(Fragment fragment, Font font) {
            int indent;
            this.fragment = fragment;
            this.fontSize = font.getSize();
            this.dx = fragment.dx;
            this.border = (int)(this.fontSize / 5.0f);
            this.dy = fragment.dy + this.border;
            this.base = fragment.base;
            this.dx1 = indent = (float)this.dx < this.fontSize / 2.0f ? 0 : (int)this.fontSize / 10;
            this.dx2 = indent / 2;
            if (font.getStyle() == 2) {
                this.dx1 = (int)((float)this.dx1 + this.fontSize / 15.0f);
                this.dx2 = (int)((float)this.dx2 - this.fontSize / 15.0f);
            }
        }

        @Override
        void drawDirect(Graphics2D gr, int xOfs, int yOfs) {
            super.drawDirect(gr, xOfs, yOfs);
            this.fragment.drawDirect(gr, xOfs + this.x, yOfs + this.y);
            int yy = yOfs + this.y - this.dy + this.base + this.border;
            if (this.fontSize < 15.0f) {
                --yy;
            }
            gr.setStroke(new BasicStroke(this.fontSize / 10.0f, 0, 2));
            gr.drawLine(xOfs + this.x + this.dx1, yy, xOfs + this.x + this.dx - this.dx2, yy);
        }
    }

    private static final class SentenceFragment
    extends Fragment {
        private ArrayList<Fragment> fragments = new ArrayList();

        private SentenceFragment() {
        }

        private void add(Fragment fragment) {
            this.fragments.add(fragment);
            fragment.x = this.dx;
            this.dx += fragment.dx;
        }

        private void pad(int p) {
            this.dx += p;
        }

        @Override
        void drawDirect(Graphics2D gr, int xOfs, int yOfs) {
            super.drawDirect(gr, xOfs, yOfs);
            for (Fragment f : this.fragments) {
                f.drawDirect(gr, this.x + xOfs, this.y + yOfs);
            }
        }

        public Fragment setUp() {
            int maxBase = 0;
            int maxAscent = 0;
            for (Fragment f : this.fragments) {
                if (maxBase < f.base) {
                    maxBase = f.base;
                }
                if (maxAscent >= f.dy - f.base) continue;
                maxAscent = f.dy - f.base;
            }
            this.dy = maxBase + maxAscent;
            this.base = maxBase;
            return this;
        }
    }

    static final class TextFragment
    extends Fragment {
        private final String text;
        private final Font font;

        private TextFragment(FontSizer sizer, Font font, String text) {
            this.font = font;
            this.text = text;
            sizer.setSizeTo(this, font, text);
        }

        @Override
        void drawDirect(Graphics2D gr, int xOfs, int yOfs) {
            super.drawDirect(gr, xOfs, yOfs);
            gr.setFont(this.font);
            gr.drawString(this.text, this.x + xOfs, this.y + yOfs);
        }
    }
}

