/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.library;

import de.neemann.digital.core.basic.Not;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.library.Visitor;
import de.neemann.digital.draw.shapes.ShapeFactory;
import de.neemann.digital.gui.Settings;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.IconCreator;
import de.neemann.gui.LineBreaker;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryNode
implements Iterable<LibraryNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LibraryNode.class);
    private static final Icon ICON_NOT_UNIQUE = IconCreator.create("testFailed.png");
    private final ArrayList<LibraryNode> children;
    private final String translatedName;
    private final String name;
    private final File file;
    private final boolean isHidden;
    private ElementTypeDescription description;
    private String toolTipText;
    private ImageIcon icon;
    private ElementLibrary library;
    private LibraryNode parent;
    private boolean unique;
    private boolean descriptionImportError = false;

    LibraryNode(String name) {
        this.name = name;
        this.translatedName = name;
        this.children = new ArrayList();
        this.description = null;
        this.toolTipText = null;
        this.file = null;
        this.isHidden = false;
    }

    private LibraryNode(ElementTypeDescription description) {
        this.children = null;
        this.description = description;
        this.toolTipText = null;
        this.name = description.getName();
        this.translatedName = description.getTranslatedName();
        this.file = null;
        this.isHidden = false;
    }

    LibraryNode(File file, boolean isLibrary) {
        this.children = null;
        this.name = file.getName();
        this.translatedName = this.name.toLowerCase().endsWith(".dig") ? this.name.substring(0, this.name.length() - 4) : this.name;
        this.isHidden = isLibrary && this.name.endsWith("-inc.dig");
        this.file = file;
    }

    LibraryNode add(LibraryNode node) {
        this.children.add(node);
        node.parent = this;
        node.setLibrary(this.library);
        return this;
    }

    LibraryNode add(ElementTypeDescription node) {
        this.add(new LibraryNode(node));
        return this;
    }

    public <V extends Visitor> V traverse(V v) {
        v.visit(this);
        if (this.children != null) {
            for (LibraryNode tn : this.children) {
                tn.traverse(v);
            }
        }
        return v;
    }

    public boolean isLeaf() {
        return this.description != null || this.file != null;
    }

    public boolean isDescriptionLoaded() {
        return this.description != null;
    }

    public ElementTypeDescription getDescriptionOrNull() {
        return this.description;
    }

    public ElementTypeDescription getDescription() throws IOException {
        if (this.description == null) {
            if (!this.unique) {
                throw new IOException(Lang.get("err_file_N0_ExistsTwiceBelow_N1", this.file.getName(), this.library.getRootFilePath()));
            }
            try {
                this.description = this.library.importElement(this.file);
            }
            catch (IOException e) {
                this.descriptionImportError = true;
                throw e;
            }
            this.library.fireLibraryChanged(this);
        }
        return this.description;
    }

    public String getTranslatedName() {
        return this.translatedName;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Iterator<LibraryNode> iterator() {
        return this.children.iterator();
    }

    public void removeAll() {
        this.children.clear();
    }

    public boolean isEmpty() {
        if (this.isLeaf()) {
            return false;
        }
        return this.children.isEmpty();
    }

    public boolean isCustom() {
        return this.file != null;
    }

    public LibraryNode getChild(int i) {
        return this.children.get(i);
    }

    public LibraryNode getChild(String name) {
        for (LibraryNode n : this.children) {
            if (!n.getName().equals(name)) continue;
            return n;
        }
        return null;
    }

    public int size() {
        return this.children == null ? 0 : this.children.size();
    }

    public int indexOf(LibraryNode node) {
        return this.children.indexOf(node);
    }

    public String toString() {
        return this.translatedName;
    }

    public Icon getIcon(ShapeFactory shapeFactory) throws IOException {
        if (this.descriptionImportError) {
            return ICON_NOT_UNIQUE;
        }
        this.getDescription();
        return this.getIconOrNull(shapeFactory);
    }

    public Icon getIconOrNull(ShapeFactory shapeFactory) {
        if (this.unique) {
            if (this.icon == null && this.description != null) {
                this.icon = this.setWideShapeFlagTo(new VisualElement(this.description.getName()).setShapeFactory(shapeFactory)).createIcon(75);
            }
            return this.icon;
        }
        return ICON_NOT_UNIQUE;
    }

    public VisualElement setWideShapeFlagTo(VisualElement visualElement) {
        try {
            if (Settings.getInstance().get(Keys.SETTINGS_IEEE_SHAPES).booleanValue() && this.getDescription().hasAttribute(Keys.WIDE_SHAPE) && !visualElement.equalsDescription(Not.DESCRIPTION)) {
                visualElement.setAttribute(Keys.WIDE_SHAPE, true);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return visualElement;
    }

    public void remove(LibraryNode child) {
        this.children.remove(child);
    }

    public LibraryNode setLibrary(ElementLibrary library) {
        if (this.library != library) {
            this.library = library;
            if (this.children != null) {
                for (LibraryNode c : this.children) {
                    c.setLibrary(library);
                }
            }
        }
        return this;
    }

    public Object[] getPath() {
        ArrayList<LibraryNode> path = new ArrayList<LibraryNode>();
        LibraryNode n = this;
        while (n != null) {
            path.add(0, n);
            n = n.parent;
        }
        return path.toArray(new Object[0]);
    }

    public void invalidate() {
        this.description = null;
        this.toolTipText = null;
        this.icon = null;
        this.library.fireLibraryChanged(this);
    }

    public String getToolTipText() {
        if (this.isCustom()) {
            if (this.isUnique()) {
                if (this.description == null) {
                    if (this.toolTipText == null) {
                        try {
                            LOGGER.debug("load tooltip from " + this.file);
                            Circuit c = Circuit.loadCircuit(this.file, null);
                            this.toolTipText = new LineBreaker().toHTML().breakLines(Lang.evalMultilingualContent(c.getAttributes().get(Keys.DESCRIPTION)));
                        }
                        catch (Exception e) {
                            this.toolTipText = Lang.get("msg_fileNotImportedYet", new Object[0]);
                        }
                    }
                    return this.toolTipText;
                }
                return new LineBreaker().toHTML().breakLines(this.description.getDescription(new ElementAttributes()));
            }
            return new LineBreaker().toHTML().breakLines(Lang.get("msg_fileIsNotUnique", new Object[0]));
        }
        return new LineBreaker().toHTML().breakLines(Lang.getNull("elem_" + this.getName() + "_tt", new Object[0]));
    }

    void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean equalsFile(LibraryNode other) {
        if (this.file == null || other.file == null) {
            return false;
        }
        return this.file.equals(other.file);
    }
}

