/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.model;

import de.neemann.digital.core.NodeWithoutDelay;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.hdl.hgs.HGSMap;
import java.util.HashSet;
import java.util.Objects;

public final class InverterConfig
implements HGSMap {
    private final HashSet<String> inputs;

    private InverterConfig(HashSet<String> inputs) {
        this.inputs = inputs;
    }

    public ObservableValue invert(String name, final ObservableValue orig) {
        if (this.inputs == null) {
            return orig;
        }
        if (!this.inputs.contains(name)) {
            return orig;
        }
        final ObservableValue out = new ObservableValue("~" + orig.getName(), orig.getBits());
        orig.addObserver(new NodeWithoutDelay(new ObservableValue[]{out}){

            @Override
            public void hasChanged() {
                out.set(orig.getValue() ^ 0xFFFFFFFFFFFFFFFFL, orig.getHighZ());
            }
        });
        out.set(orig.getValue() ^ 0xFFFFFFFFFFFFFFFFL, orig.getHighZ());
        return out;
    }

    public String toString() {
        return this.inputs.toString();
    }

    public boolean contains(String name) {
        if (this.inputs == null) {
            return false;
        }
        return this.inputs.contains(name);
    }

    public boolean isEmpty() {
        if (this.inputs == null) {
            return true;
        }
        return this.inputs.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InverterConfig that = (InverterConfig)o;
        return Objects.equals(this.inputs, that.inputs);
    }

    public int hashCode() {
        return this.inputs != null ? this.inputs.hashCode() : 0;
    }

    public int size() {
        if (this.inputs == null) {
            return 0;
        }
        return this.inputs.size();
    }

    @Override
    public Object hgsMapGet(String key) {
        if (this.inputs == null) {
            return false;
        }
        return this.inputs.contains(key);
    }

    /* synthetic */ InverterConfig(HashSet hashSet, InverterConfig inverterConfig) {
        this(hashSet);
    }

    public static class Builder {
        private HashSet<String> inputs;

        public Builder add(String name) {
            if (this.inputs == null) {
                this.inputs = new HashSet();
            }
            this.inputs.add(name);
            return this;
        }

        public InverterConfig build() {
            return new InverterConfig(this.inputs, null);
        }
    }
}

