/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.Value;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.core.io.ButtonLED;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.ButtonShape;
import de.neemann.digital.draw.shapes.InteractorInterface;

public class ButtonLEDShape
extends ButtonShape {
    private final PinDescription input;
    private final PinDescription output;
    private final Style color;
    private ObservableValue inputValue;
    private Value ledValue;
    private ButtonLED button;

    public ButtonLEDShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        super(attr, inputs, outputs);
        this.input = (PinDescription)inputs.get(0);
        this.output = (PinDescription)outputs.get(0);
        this.color = Style.NORMAL.deriveStyle(0, true, attr.get(Keys.COLOR));
        this.setCenterLabel(false);
    }

    @Override
    public Pins getPins() {
        return new Pins().add(new Pin(new Vector(0, 0), this.output)).add(new Pin(new Vector(0, 20), this.input));
    }

    @Override
    public InteractorInterface applyStateMonitor(IOState ioState) {
        this.inputValue = ioState.getInput(0);
        this.button = (ButtonLED)ioState.getElement();
        return super.applyStateMonitor(ioState);
    }

    @Override
    public void readObservableValues() {
        if (this.inputValue != null) {
            this.ledValue = this.inputValue.getCopy();
        }
    }

    @Override
    public void drawTo(Graphic graphic, Style heighLight) {
        super.drawTo(graphic, heighLight);
        boolean ledOn = this.ledValue == null || this.ledValue.getBool() & !this.ledValue.isHighZ();
        boolean pressed = this.button != null && this.button.isPressed();
        Vector center = this.getButtonCenter(pressed);
        if (ledOn) {
            graphic.drawCircle(center.add(-10, -10), center.add(10, 10), this.color);
        }
        graphic.drawCircle(center.add(-10, -10), center.add(10, 10), Style.THIN);
    }
}

