/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.InteractorInterface;
import de.neemann.digital.draw.shapes.Shape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DILShape
implements Shape {
    static final float CIRC = (float)(4.0 * (Math.sqrt(2.0) - 1.0) / 3.0);
    private static final int SPACING = 2;
    private static final int RAD = 10;
    private static final int BEZ = Math.round(10.0f * CIRC);
    private final int pinCount;
    private final Pins pins;
    private final int width;
    private final String shortName;
    private final String label;
    private final ShapePinMap map;

    public DILShape(String shortName, PinDescriptions inputs, PinDescriptions outputs, String label, ElementAttributes attr) {
        this.shortName = shortName;
        this.label = label;
        this.width = attr.get(Keys.WIDTH) + 1;
        this.map = new ShapePinMap(this.width, attr.get(Keys.PINCOUNT));
        this.map.addAll(inputs);
        this.map.addAll(outputs);
        this.pinCount = this.map.getPinCount();
        this.pins = this.map.createPins();
    }

    @Override
    public Pins getPins() {
        return this.pins;
    }

    @Override
    public InteractorInterface applyStateMonitor(IOState ioState) {
        return null;
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        int dp = 40;
        int pin = dp / 4;
        int x = this.width * 20;
        int h = this.pinCount / 2 * dp - 20;
        int i = 0;
        while (i < this.pinCount / 2) {
            int y = i * dp;
            graphic.drawPolygon(new Polygon(false).add(pin, y - pin).add(2, y - pin).add(2, y + pin).add(pin, y + pin), Style.NORMAL);
            graphic.drawText(new Vector(pin + 5, y), this.map.getText(i + 1), Orientation.LEFTCENTER, Style.SHAPE_PIN);
            graphic.drawPolygon(new Polygon(false).add(x - pin, y - pin).add(x - 2, y - pin).add(x - 2, y + pin).add(x - pin, y + pin), Style.NORMAL);
            graphic.drawText(new Vector(x - pin - 5, y), this.map.getText(this.pinCount - i), Orientation.RIGHTCENTER, Style.SHAPE_PIN);
            ++i;
        }
        graphic.drawPolygon(new Polygon(true).add(pin, -20).add(x / 2 - 10, -20).add(new Vector(x / 2 - 10, -20 + BEZ), new Vector(x / 2 - BEZ, -10), new Vector(x / 2, -10)).add(new Vector(x / 2 + BEZ, -10), new Vector(x / 2 + 10, -20 + BEZ), new Vector(x / 2 + 10, -20)).add(x - pin, -20).add(x - pin, h).add(pin, h), Style.NORMAL);
        graphic.drawText(new Vector(x / 2, 10), new Vector(x / 2, 40), this.shortName, Orientation.LEFTCENTER, Style.NORMAL_TEXT);
        if (this.label != null && this.label.length() > 0) {
            graphic.drawText(new Vector(x / 2, h + 10), this.label, Orientation.CENTERTOP, Style.NORMAL_TEXT);
        }
    }

    private static final class ShapePinMap {
        private final int width;
        private final HashMap<Integer, PinDescription> map;
        private ArrayList<PinDescription> notAssigned;
        private int pinCount;

        private ShapePinMap(int width, int minPinCount) {
            this.width = width;
            this.pinCount = minPinCount;
            this.map = new HashMap();
            this.notAssigned = new ArrayList();
        }

        private void addAll(PinDescriptions pinDescriptions) {
            for (PinDescription p : pinDescriptions) {
                this.add(p);
            }
        }

        private void add(PinDescription p) {
            int num = 0;
            try {
                String str = p.getPinNumber();
                if (str != null) {
                    num = Integer.parseInt(str);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (num == 0 || this.map.containsKey(num)) {
                this.notAssigned.add(p);
            } else {
                this.map.put(num, p);
                if (num > this.pinCount) {
                    this.pinCount = num;
                }
            }
        }

        private int getPinCount() {
            if (this.notAssigned != null) {
                this.assignNotAssigned();
            }
            return this.pinCount;
        }

        private void assignNotAssigned() {
            int num = 1;
            for (PinDescription p : this.notAssigned) {
                while (this.map.containsKey(num)) {
                    ++num;
                }
                this.map.put(num, p);
            }
            if (num > this.pinCount) {
                this.pinCount = num;
            }
            this.notAssigned = null;
            if ((this.pinCount & 1) == 1) {
                ++this.pinCount;
            }
        }

        private Vector getPinPos(int pinNumber) {
            if (pinNumber <= this.pinCount / 2) {
                return new Vector(0, (pinNumber - 1) * 20 * 2);
            }
            return new Vector(20 * this.width, (this.pinCount - pinNumber) * 20 * 2);
        }

        private Pins createPins() {
            if (this.notAssigned != null) {
                this.assignNotAssigned();
            }
            Pins pins = new Pins();
            for (Map.Entry<Integer, PinDescription> e : this.map.entrySet()) {
                pins.add(new Pin(this.getPinPos(e.getKey()), e.getValue()));
            }
            return pins;
        }

        private String getText(int i) {
            PinDescription p = this.map.get(i);
            if (p != null) {
                return p.getName();
            }
            return "";
        }
    }
}

