/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.Signal;
import de.neemann.digital.core.SyncAccess;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.data.DataPlotter;
import de.neemann.digital.data.Value;
import de.neemann.digital.data.ValueTable;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.model.ModelCreator;
import de.neemann.digital.draw.model.ModelEntry;
import de.neemann.digital.draw.shapes.Interactor;
import de.neemann.digital.draw.shapes.Shape;
import de.neemann.digital.gui.components.OrderMerger;
import de.neemann.digital.gui.components.data.ValueTableObserver;
import de.neemann.digital.testing.parser.TestRow;
import java.util.ArrayList;

public class DataShape
implements Shape {
    private final boolean microStep;
    private final int maxSize;
    private ValueTable logDataModel;
    private ValueTable logData;
    private SyncAccess modelSync = SyncAccess.NOSYNC;

    public DataShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        this.microStep = attr.get(Keys.MICRO_STEP);
        this.maxSize = attr.get(Keys.MAX_STEP_COUNT);
    }

    @Override
    public Pins getPins() {
        return new Pins();
    }

    @Override
    public Interactor applyStateMonitor(IOState ioState) {
        return null;
    }

    @Override
    public void readObservableValues() {
        if (this.logDataModel != null) {
            this.logData = new ValueTable(this.logDataModel);
        }
    }

    @Override
    public void drawTo(Graphic graphic, Style heighLight) {
        if (this.logData == null) {
            this.logData = new ValueTable("A", "B", "C").add(new TestRow(new Value(0L), new Value(0L), new Value(0L))).add(new TestRow(new Value(0L), new Value(1L), new Value(0L)));
        }
        new DataPlotter(this.logData, this.modelSync).drawTo(graphic, null);
    }

    @Override
    public void registerModel(ModelCreator modelCreator, Model model, ModelEntry element) {
        this.modelSync = model;
        ArrayList<Signal> signals = model.getSignalsCopy();
        signals.removeIf(signal -> !signal.isShowInGraph());
        new OrderMerger<String, Signal>(modelCreator.getCircuit().getMeasurementOrdering()){

            @Override
            public boolean equals(Signal a, String b) {
                return a.getName().equals(b);
            }
        }.order(signals);
        boolean ms = this.microStep;
        if (model.getAsyncInfos() != null) {
            ms = true;
        }
        ValueTableObserver valueTableObserver = new ValueTableObserver(ms, signals, this.maxSize);
        this.logDataModel = valueTableObserver.getLogData();
        model.addObserver(valueTableObserver);
    }
}

