/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.SyncAccess;
import de.neemann.digital.core.Value;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.ColorKey;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.Interactor;
import de.neemann.digital.draw.shapes.Shape;
import de.neemann.digital.gui.components.CircuitComponent;
import java.awt.Point;

public class DipSwitchShape
implements Shape {
    private static final Polygon FRAME = new Polygon(true).add(-1, 10).add(-59, 10).add(-59, -10).add(-1, -10);
    private static final Polygon ON = new Polygon(true).add(-5, 6).add(-30, 6).add(-30, -6).add(-5, -6);
    private static final Polygon OFF = new Polygon(true).add(-55, 6).add(-30, 6).add(-30, -6).add(-55, -6);
    private static final Style STYLE = Style.THIN.deriveFillStyle(ColorKey.PINS);
    private final String label;
    private final PinDescriptions outputs;
    private final boolean defValue;
    private IOState ioState;
    private Value value;

    public DipSwitchShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        this.outputs = outputs;
        this.label = attr.getLabel();
        this.defValue = attr.get(Keys.DIP_DEFAULT);
    }

    @Override
    public Pins getPins() {
        return new Pins().add(new Pin(new Vector(0, 0), (PinDescription)this.outputs.get(0)));
    }

    @Override
    public Interactor applyStateMonitor(IOState ioState) {
        this.ioState = ioState;
        return new Interactor(){

            @Override
            public void clicked(CircuitComponent cc, Point pos, IOState ioState, Element element, SyncAccess modelSync) {
                ObservableValue value = ioState.getOutput(0);
                modelSync.modify(() -> {
                    ObservableValue observableValue2 = value.setValue(1L - value.getValue());
                });
            }
        };
    }

    @Override
    public void readObservableValues() {
        if (this.ioState != null) {
            this.value = this.ioState.getOutput(0).getCopy();
        }
    }

    @Override
    public void drawTo(Graphic graphic, Style heighLight) {
        graphic.drawPolygon(FRAME, Style.NORMAL);
        Vector pos = new Vector(-70, 0);
        if (this.label.length() > 0) {
            graphic.drawText(pos, this.label, Orientation.RIGHTCENTER, Style.NORMAL);
        }
        boolean on = this.defValue;
        if (this.value != null) {
            on = this.value.getBool();
        }
        if (on) {
            graphic.drawPolygon(ON, STYLE);
        } else {
            graphic.drawPolygon(OFF, STYLE);
        }
    }
}

