/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.core.switching.NFET;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.InteractorInterface;
import de.neemann.digital.draw.shapes.Shape;

public abstract class FETShape
implements Shape {
    private final PinDescriptions inputs;
    private final PinDescriptions outputs;
    private final String label;
    private int xOffs = 8;
    private NFET fet;
    private boolean isClosed;

    FETShape(ElementAttributes attributes, PinDescriptions inputs, PinDescriptions outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.label = attributes.getLabel();
    }

    void setXOffs(int xOffs) {
        this.xOffs = xOffs;
    }

    @Override
    public InteractorInterface applyStateMonitor(IOState ioState) {
        this.fet = (NFET)ioState.getElement();
        return null;
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        int g = 5;
        graphic.drawPolygon(new Polygon(false).add(20, 0).add(this.xOffs, 0).add(this.xOffs, 5), Style.NORMAL);
        graphic.drawPolygon(new Polygon(false).add(20, 40).add(this.xOffs, 40).add(this.xOffs, 35), Style.NORMAL);
        graphic.drawLine(new Vector(this.xOffs, 15), new Vector(this.xOffs, 25), Style.NORMAL);
        graphic.drawLine(new Vector(1, 0), new Vector(1, 40), Style.NORMAL);
        if (this.label != null && this.label.length() > 0) {
            graphic.drawText(new Vector(30, 40), this.label, Orientation.LEFTBOTTOM, Style.SHAPE_PIN);
        }
        if (this.fet != null) {
            this.drawSwitch(graphic);
        }
    }

    @Override
    public void readObservableValues() {
        if (this.fet != null) {
            this.isClosed = this.fet.isClosed();
        }
    }

    private void drawSwitch(Graphic graphic) {
        FETShape.drawSwitch(graphic, this.isClosed);
    }

    public static void drawSwitch(Graphic graphic, boolean closed) {
        if (closed) {
            graphic.drawLine(new Vector(30, 0), new Vector(30, 20), Style.SHAPE_PIN);
        } else {
            graphic.drawLine(new Vector(30, 0), new Vector(30, 5), Style.SHAPE_PIN);
            graphic.drawPolygon(new Polygon(false).add(25, 7).add(30, 15).add(30, 20), Style.SHAPE_PIN);
        }
    }

    public PinDescriptions getInputs() {
        return this.inputs;
    }

    public PinDescriptions getOutputs() {
        return this.outputs;
    }
}

