/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.Interactor;
import de.neemann.digital.draw.shapes.Shape;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;

public class GenericCodeShape
implements Shape {
    private static final Style STYLE = Style.NORMAL.deriveFontStyle(Style.NORMAL.getFontSize(), true);
    private final ArrayList<String> text;

    public GenericCodeShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        String gen = attr.get(Keys.GENERIC);
        this.text = new ArrayList();
        if (gen.isEmpty()) {
            this.text.add(Lang.get("elem_GenericCode", new Object[0]));
        } else {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < gen.length()) {
                char c = gen.charAt(i);
                switch (c) {
                    case ' ': {
                        sb.append("\u00a0");
                        break;
                    }
                    case '_': {
                        sb.append("\\_");
                        break;
                    }
                    case '^': {
                        sb.append("\\^");
                        break;
                    }
                    case '\n': {
                        this.text.add(sb.toString());
                        sb.setLength(0);
                    }
                    default: {
                        sb.append(c);
                    }
                }
                ++i;
            }
            if (sb.length() > 0) {
                this.text.add(sb.toString());
            }
        }
    }

    @Override
    public Pins getPins() {
        return new Pins();
    }

    @Override
    public Interactor applyStateMonitor(IOState ioState) {
        return null;
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        Vector pos = new Vector(0, 0);
        int dy = STYLE.getFontSize() * 20 / 16;
        for (String s : this.text) {
            graphic.drawText(pos, s, Orientation.LEFTCENTER, STYLE);
            pos = pos.add(0, dy);
        }
    }
}

