/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.SyncAccess;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.core.memory.RAMInterface;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.model.ModelCreator;
import de.neemann.digital.draw.model.ModelEntry;
import de.neemann.digital.draw.shapes.GenericShape;
import de.neemann.digital.draw.shapes.Interactor;
import de.neemann.digital.gui.components.CircuitComponent;
import de.neemann.digital.gui.components.DataEditor;
import java.awt.Point;

public class RAMShape
extends GenericShape {
    private final int dataBits;
    private final int addrBits;
    private final String dialogTitle;
    private Model model;

    public RAMShape(ElementAttributes attr, ElementTypeDescription description) throws NodeException, PinException {
        this(attr, description, 3);
    }

    public RAMShape(ElementAttributes attr, ElementTypeDescription description, int width) throws NodeException, PinException {
        super(description.getShortName(), description.getInputDescription(attr), description.getOutputDescriptions(attr), attr.getLabel(), true, width);
        this.dialogTitle = attr.getLabel().length() > 0 ? attr.getLabel() : description.getShortName();
        this.dataBits = attr.get(Keys.BITS);
        this.addrBits = attr.get(Keys.ADDR_BITS);
        this.setInverterConfig(attr.get(Keys.INVERTER_CONFIG));
    }

    @Override
    public Interactor applyStateMonitor(IOState ioState) {
        return new Interactor(){

            @Override
            public void clicked(CircuitComponent cc, Point pos, IOState ioState, Element element, SyncAccess modelSync) {
                if (element instanceof RAMInterface) {
                    RAMInterface ram = (RAMInterface)((Object)element);
                    DataField dataField = ram.getMemory();
                    DataEditor dataEditor = new DataEditor(cc, dataField, RAMShape.this.dataBits, RAMShape.this.addrBits, true, modelSync, ram.getValueFormatter());
                    if (element instanceof Node) {
                        dataEditor.setNode((Node)((Object)element));
                    }
                    dataEditor.showDialog(RAMShape.this.dialogTitle, RAMShape.this.model);
                }
            }
        };
    }

    @Override
    public void registerModel(ModelCreator modelCreator, Model model, ModelEntry element) {
        this.model = model;
    }
}

