/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.Value;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.Interactor;
import de.neemann.digital.draw.shapes.SevenShape;

public class SevenSegHexShape
extends SevenShape {
    private static final int[] TABLE = new int[]{63, 6, 91, 79, 102, 109, 125, 7, 127, 111, 119, 124, 57, 94, 121, 113};
    private final PinDescriptions inputs;
    private Pins pins;
    private Value input;
    private Value dp;
    private IOState ioState;

    public SevenSegHexShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        super(attr);
        this.inputs = inputs;
    }

    @Override
    public void readObservableValues() {
        if (this.ioState != null) {
            this.input = this.ioState.getInput(0).getCopy();
            this.dp = this.ioState.getInput(1).getCopy();
        }
    }

    @Override
    protected boolean getStyle(int i) {
        if (this.input == null) {
            return true;
        }
        if (i == 7) {
            return this.dp.getBool();
        }
        if (this.input.isHighZ()) {
            return false;
        }
        int v = (int)this.input.getValue() & 0xF;
        return ((v = TABLE[v]) & 1 << i) != 0;
    }

    @Override
    public Pins getPins() {
        if (this.pins == null) {
            this.pins = new Pins().add(new Pin(new Vector(40, 140), (PinDescription)this.inputs.get(0))).add(new Pin(new Vector(60, 140), (PinDescription)this.inputs.get(1)));
        }
        return this.pins;
    }

    @Override
    public Interactor applyStateMonitor(IOState ioState) {
        this.ioState = ioState;
        return null;
    }
}

