/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.ModelEvent;
import de.neemann.digital.core.ModelEventType;
import de.neemann.digital.core.ModelStateObserverTyped;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.core.io.CommonConnectionType;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.model.ModelCreator;
import de.neemann.digital.draw.model.ModelEntry;
import de.neemann.digital.draw.shapes.Interactor;
import de.neemann.digital.draw.shapes.SevenShape;
import java.util.ArrayList;

public class SevenSegShape
extends SevenShape {
    private final PinDescriptions inputPins;
    private final boolean commonConnection;
    private final int persistenceTime;
    private final boolean anode;
    private LEDState[] ledStates;
    private final boolean[] displayStates;
    private Pins pins;
    private PersistenceHandler persistenceHandler;

    public SevenSegShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        super(attr);
        this.inputPins = inputs;
        this.commonConnection = attr.get(Keys.COMMON_CONNECTION);
        this.anode = attr.get(Keys.COMMON_CONNECTION_TYPE).equals((Object)CommonConnectionType.anode);
        this.persistenceTime = attr.get(Keys.LED_PERSIST_TIME);
        this.displayStates = new boolean[8];
    }

    @Override
    public Pins getPins() {
        if (this.pins == null) {
            this.pins = new Pins();
            this.pins.add(new Pin(new Vector(0, 0), (PinDescription)this.inputPins.get(0)));
            this.pins.add(new Pin(new Vector(20, 0), (PinDescription)this.inputPins.get(1)));
            this.pins.add(new Pin(new Vector(40, 0), (PinDescription)this.inputPins.get(2)));
            this.pins.add(new Pin(new Vector(60, 0), (PinDescription)this.inputPins.get(3)));
            this.pins.add(new Pin(new Vector(0, 140), (PinDescription)this.inputPins.get(4)));
            this.pins.add(new Pin(new Vector(20, 140), (PinDescription)this.inputPins.get(5)));
            this.pins.add(new Pin(new Vector(40, 140), (PinDescription)this.inputPins.get(6)));
            this.pins.add(new Pin(new Vector(60, 140), (PinDescription)this.inputPins.get(7)));
            if (this.commonConnection) {
                this.pins.add(new Pin(new Vector(80, 140), (PinDescription)this.inputPins.get(8)));
            }
        }
        return this.pins;
    }

    @Override
    public Interactor applyStateMonitor(IOState ioState) {
        this.ledStates = new LEDState[8];
        int i = 0;
        while (i < 8) {
            LEDState ledState = this.createLEDState(i, ioState.getInputs());
            this.ledStates[i] = this.persistenceTime == 0 ? ledState : this.persistenceHandler.persist(ledState, this.persistenceTime);
            ++i;
        }
        return null;
    }

    @Override
    public void registerModel(ModelCreator modelCreator, Model model, ModelEntry element) {
        if (this.persistenceTime > 0) {
            this.persistenceHandler = model.getOrCreateObserver(PersistenceHandler.class, () -> new PersistenceHandler());
        }
    }

    private LEDState createLEDState(int i, ObservableValues inputs) {
        if (this.commonConnection) {
            return new CommonConnection((ObservableValue)inputs.get(i), (ObservableValue)inputs.get(8), this.anode);
        }
        ObservableValue in = (ObservableValue)inputs.get(i);
        return () -> !in.isHighZ() && in.getBool();
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        super.drawTo(graphic, highLight);
        if (this.commonConnection) {
            graphic.drawLine(new Vector(70, 139), new Vector(80, 139), Style.NORMAL);
        }
    }

    @Override
    public void readObservableValues() {
        if (this.ledStates != null) {
            int i = 0;
            while (i < 8) {
                this.displayStates[i] = this.ledStates[i].getState();
                ++i;
            }
        }
    }

    @Override
    protected boolean getStyle(int i) {
        if (this.ledStates == null) {
            return true;
        }
        return this.displayStates[i];
    }

    private static final class CommonConnection
    implements LEDState {
        private final ObservableValue led;
        private final ObservableValue cc;
        private final boolean anode;

        private CommonConnection(ObservableValue led, ObservableValue cc, boolean anode) {
            this.led = led;
            this.cc = cc;
            this.anode = anode;
        }

        @Override
        public boolean getState() {
            boolean on;
            boolean highZ = this.led.isHighZ() || this.cc.isHighZ();
            boolean bl = on = this.led.getBool() != this.cc.getBool() && this.led.getBool() ^ this.anode;
            return !highZ && on;
        }
    }

    static interface LEDState {
        public boolean getState();
    }

    private static final class PersistenceHandler
    implements ModelStateObserverTyped {
        private final ArrayList<PersistenceOfVision> segments = new ArrayList();

        private PersistenceHandler() {
        }

        @Override
        public void handleEvent(ModelEvent event) {
            if (event.getType() == ModelEventType.STEP || event.getType() == ModelEventType.CHECKBURN) {
                for (PersistenceOfVision ag : this.segments) {
                    ag.check();
                }
            }
        }

        @Override
        public ModelEventType[] getEvents() {
            return new ModelEventType[]{ModelEventType.STEP, ModelEventType.CHECKBURN};
        }

        public PersistenceOfVision persist(LEDState state, int persistenceTime) {
            PersistenceOfVision ag = new PersistenceOfVision(state, persistenceTime);
            this.segments.add(ag);
            return ag;
        }
    }

    private static final class PersistenceOfVision
    implements LEDState {
        private final LEDState parent;
        private final int persistenceTime;
        private int timeVisible;

        private PersistenceOfVision(LEDState parent, int persistenceTime) {
            this.parent = parent;
            this.persistenceTime = persistenceTime;
        }

        @Override
        public boolean getState() {
            return this.timeVisible > 0;
        }

        public void check() {
            if (this.parent.getState()) {
                this.timeVisible = this.persistenceTime;
            }
            if (this.timeVisible > 0) {
                --this.timeVisible;
            }
        }
    }
}

