/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.core.switching.TransGate;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.GraphicTransform;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Transform;
import de.neemann.digital.draw.graphics.TransformRotate;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.FETShape;
import de.neemann.digital.draw.shapes.InteractorInterface;
import de.neemann.digital.draw.shapes.Shape;

public class TransGateShape
implements Shape {
    private static final int RAD = 4;
    private static final int P = 15;
    private static final Polygon TOP = new Polygon(true).add(0, 0).add(0, -20).add(40, 0).add(40, -20).add(0, 0);
    private static final Polygon BOTTOM = new Polygon(true).add(0, 0).add(0, 20).add(40, 0).add(40, 20).add(0, 0);
    private static final Transform TRANS_SWITCH = new TransformRotate(new Vector(10, 30), 1);
    private final PinDescriptions input;
    private final PinDescriptions output;
    private TransGate transGate;
    private boolean isClosed;

    public TransGateShape(ElementAttributes attr, PinDescriptions input, PinDescriptions output) {
        this.input = input;
        this.output = output;
    }

    @Override
    public Pins getPins() {
        return new Pins().add(new Pin(new Vector(20, -20), (PinDescription)this.input.get(0))).add(new Pin(new Vector(20, 20), (PinDescription)this.input.get(1))).add(new Pin(new Vector(0, 0), (PinDescription)this.output.get(0))).add(new Pin(new Vector(40, 0), (PinDescription)this.output.get(1)));
    }

    @Override
    public InteractorInterface applyStateMonitor(IOState ioState) {
        this.transGate = (TransGate)ioState.getElement();
        return null;
    }

    @Override
    public void readObservableValues() {
        if (this.transGate != null) {
            this.isClosed = this.transGate.isClosed();
        }
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        graphic.drawPolygon(TOP, Style.NORMAL);
        graphic.drawPolygon(BOTTOM, Style.NORMAL);
        graphic.drawLine(new Vector(20, -20), new Vector(20, -10), Style.NORMAL);
        graphic.drawCircle(new Vector(16, 11), new Vector(24, 19), Style.NORMAL);
        if (this.transGate != null) {
            FETShape.drawSwitch(new GraphicTransform(graphic, TRANS_SWITCH), this.isClosed);
        }
    }
}

