/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes.custom;

import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Transform;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.graphics.VectorInterface;
import de.neemann.digital.draw.shapes.Drawable;
import de.neemann.digital.lang.Lang;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public final class CustomShapeDescription
implements Iterable<Holder> {
    private final HashMap<String, Pin> pins;
    private final ArrayList<Holder> drawables;
    private final TextHolder label;

    private CustomShapeDescription(HashMap<String, Pin> pins, ArrayList<Holder> drawables, TextHolder label) {
        this.pins = pins;
        this.drawables = drawables;
        this.label = label;
    }

    Pin getPin(String name) throws PinException {
        Pin pin = this.pins.get(name);
        if (pin == null) {
            throw new PinException(Lang.get("err_customShapeHasNoPin_N", name));
        }
        return pin;
    }

    @Override
    public Iterator<Holder> iterator() {
        return this.drawables.iterator();
    }

    public void transform(Transform tr) {
        for (Holder h : this.drawables) {
            h.transform(tr);
        }
        for (Pin p : this.pins.values()) {
            p.transform(tr);
        }
        if (this.label != null) {
            this.label.transform(tr);
        }
    }

    public int getPinCount() {
        return this.pins.size();
    }

    public TextHolder getLabel() {
        return this.label;
    }

    public Collection<Pin> getPins() {
        return this.pins.values();
    }

    public boolean isEmpty() {
        return this.drawables.isEmpty() && this.pins.isEmpty();
    }

    public void checkCompatibility(Circuit circuit) throws PinException {
        PinDescription[] inputNames;
        ObservableValues outputNames = circuit.getOutputNames();
        for (ObservableValue out : outputNames) {
            this.getPin(out.getName());
        }
        PinDescription[] pinDescriptionArray = inputNames = circuit.getInputNames();
        int n = inputNames.length;
        int n2 = 0;
        while (n2 < n) {
            PinDescription in = pinDescriptionArray[n2];
            this.getPin(in.getName());
            ++n2;
        }
        int pinsNum = outputNames.size() + inputNames.length;
        if (pinsNum != this.pins.size()) {
            throw new PinException(Lang.get("err_morePinsDefinedInSVGAsNeeded", new Object[0]));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomShapeDescription customShapeDescription = (CustomShapeDescription)o;
        return customShapeDescription.isEmpty() && this.isEmpty();
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        return super.hashCode();
    }

    /* synthetic */ CustomShapeDescription(HashMap hashMap, ArrayList arrayList, TextHolder textHolder, CustomShapeDescription customShapeDescription) {
        this(hashMap, arrayList, textHolder);
    }

    public static final class Builder {
        private final HashMap<String, Pin> pins = new HashMap();
        private final ArrayList<Holder> drawables = new ArrayList();
        private TextHolder label;

        public Builder setLabel(Vector pos0, Vector pos1, Orientation textOrientation, int fontSize, Color filled) {
            this.label = new TextHolder(pos0, pos1, "", textOrientation, fontSize, filled);
            return this;
        }

        public Builder addPin(String name, Vector pos, boolean showLabel) {
            this.pins.put(name, new Pin(pos, showLabel));
            return this;
        }

        public Builder addLine(Vector p1, Vector p2, int thickness, Color color) {
            this.drawables.add(new LineHolder(p1, p2, thickness, color));
            return this;
        }

        public Builder addCircle(Vector p1, Vector p2, int thickness, Color color, boolean filled) {
            this.drawables.add(new CircleHolder(p1, p2, thickness, color, filled));
            return this;
        }

        public Builder addPolygon(Polygon poly, int thickness, Color color, boolean filled) {
            this.drawables.add(new PolygonHolder(poly, thickness, filled, color));
            return this;
        }

        public Builder addText(Vector p1, Vector p2, String text, Orientation orientation, int size, Color color) {
            this.drawables.add(new TextHolder(p1, p2, text, orientation, size, color));
            return this;
        }

        public CustomShapeDescription build() {
            return new CustomShapeDescription(this.pins, this.drawables, this.label, null);
        }
    }

    public static final class CircleHolder
    implements Holder {
        private Vector p1;
        private Vector p2;
        private final int thickness;
        private final Color color;
        private final boolean filled;

        private CircleHolder(Vector p1, Vector p2, int thickness, Color color, boolean filled) {
            this.p1 = p1;
            this.p2 = p2;
            this.thickness = thickness;
            this.color = color;
            this.filled = filled;
        }

        @Override
        public void drawTo(Graphic graphic, Style highLight) {
            graphic.drawCircle(this.p1, this.p2, Style.NORMAL.deriveStyle(this.thickness, this.filled, this.color));
        }

        public VectorInterface getP1() {
            return this.p1;
        }

        public VectorInterface getP2() {
            return this.p2;
        }

        @Override
        public void transform(Transform tr) {
            this.p1 = this.p1.transform(tr).round();
            this.p2 = this.p2.transform(tr).round();
        }
    }

    static interface Holder
    extends Drawable,
    Transformable {
    }

    public static final class LineHolder
    implements Holder {
        private Vector p1;
        private Vector p2;
        private final int thickness;
        private final Color color;

        private LineHolder(Vector p1, Vector p2, int thickness, Color color) {
            this.p1 = p1;
            this.p2 = p2;
            this.thickness = thickness;
            this.color = color;
        }

        @Override
        public void drawTo(Graphic graphic, Style highLight) {
            graphic.drawLine(this.p1, this.p2, Style.NORMAL.deriveStyle(this.thickness, false, this.color));
        }

        public VectorInterface getP1() {
            return this.p1;
        }

        public VectorInterface getP2() {
            return this.p2;
        }

        @Override
        public void transform(Transform tr) {
            this.p1 = this.p1.transform(tr).round();
            this.p2 = this.p2.transform(tr).round();
        }
    }

    public static final class Pin
    implements Transformable {
        private Vector pos;
        private boolean showLabel;

        private Pin(Vector pos, boolean showLabel) {
            this.pos = pos;
            this.showLabel = showLabel;
        }

        boolean isShowLabel() {
            return this.showLabel;
        }

        public Vector getPos() {
            return this.pos;
        }

        @Override
        public void transform(Transform tr) {
            this.pos = this.pos.transform(tr).round();
        }
    }

    public static final class PolygonHolder
    implements Holder {
        private Polygon poly;
        private final int thickness;
        private final boolean filled;
        private final Color color;

        private PolygonHolder(Polygon poly, int thickness, boolean filled, Color color) {
            this.poly = poly;
            this.thickness = thickness;
            this.filled = filled;
            this.color = color;
        }

        @Override
        public void drawTo(Graphic graphic, Style highLight) {
            graphic.drawPolygon(this.poly, Style.NORMAL.deriveStyle(this.thickness, this.filled, this.color));
        }

        public Polygon getPolygon() {
            return this.poly;
        }

        @Override
        public void transform(Transform tr) {
            this.poly = this.poly.transform(tr);
        }
    }

    public static final class TextHolder
    implements Holder {
        private Vector p1;
        private Vector p2;
        private final String text;
        private final Orientation orientation;
        private final int size;
        private final Color color;

        private TextHolder(Vector p1, Vector p2, String text, Orientation orientation, int size, Color color) {
            this.p1 = p1;
            this.p2 = p2;
            this.text = text;
            this.orientation = orientation;
            this.size = size;
            this.color = color;
        }

        @Override
        public void drawTo(Graphic graphic, Style highLight) {
            this.drawText(graphic, this.text);
        }

        public void drawText(Graphic graphic, String text) {
            graphic.drawText(this.p1, this.p2, text, this.orientation, Style.NORMAL.deriveFontStyle(this.size, true).deriveColor(this.color));
        }

        @Override
        public void transform(Transform tr) {
            this.p1 = this.p1.transform(tr).round();
            this.p2 = this.p2.transform(tr).round();
        }

        public Vector getPos() {
            return this.p1;
        }

        public int getFontSize() {
            return this.size;
        }

        public String getText() {
            return this.text;
        }
    }

    private static interface Transformable {
        public void transform(Transform var1);
    }
}

