/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.fsm;

import java.util.Arrays;
import java.util.LinkedList;

public final class Permute {
    private Permute() {
    }

    static void permute(int size, PermListener listener) throws PermListenerException {
        Permute.permute(size, size, listener);
    }

    static void permute(int size, int range, PermListener listener) throws PermListenerException {
        int[] perms = new int[range];
        int i = 0;
        while (i < range) {
            perms[i] = i;
            ++i;
        }
        Permute.permute(perms, 0, size, listener);
    }

    private static void permute(int[] perms, int fixed, int size, PermListener listener) throws PermListenerException {
        if (fixed == size) {
            listener.perm(perms);
            return;
        }
        Permute.permute(perms, fixed + 1, size, listener);
        int i = fixed + 1;
        while (i < perms.length) {
            Permute.swap(perms, fixed, i);
            Permute.permute(perms, fixed + 1, size, listener);
            Permute.swap(perms, fixed, i);
            ++i;
        }
    }

    private static void swap(int[] perms, int n0, int n1) {
        int t = perms[n0];
        perms[n0] = perms[n1];
        perms[n1] = t;
    }

    public static class Divider
    implements PermListener {
        private final PermListener parent;
        private final int div;
        private int count;

        public Divider(PermListener parent, int div) {
            this.parent = parent;
            this.div = div;
        }

        @Override
        public void perm(int[] perm) throws PermListenerException {
            ++this.count;
            if (this.count >= this.div) {
                this.count = 0;
                this.parent.perm(perm);
            }
        }
    }

    public static interface PermListener {
        public void perm(int[] var1) throws PermListenerException;
    }

    public static class PermListenerException
    extends Exception {
        public PermListenerException(String message) {
            super(message);
        }

        public PermListenerException(Exception cause) {
            super(cause);
        }
    }

    public static final class PermPull {
        private static final int MAXSIZE = 50;
        private final LinkedList<int[]> queue = new LinkedList();
        private boolean running = true;

        public PermPull(int size) {
            this(size, size);
        }

        public PermPull(int size, int range) {
            Thread thread = new Thread(() -> {
                try {
                    Permute.permute(size, range, perm -> {
                        LinkedList<int[]> linkedList = this.queue;
                        synchronized (linkedList) {
                            try {
                                while (this.queue.size() >= 50) {
                                    this.queue.wait();
                                }
                                this.queue.add(Arrays.copyOf(perm, perm.length));
                                this.queue.notify();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            if (!this.running) {
                                throw new PermListenerException("terminated");
                            }
                        }
                    });
                }
                catch (PermListenerException e) {
                    e.printStackTrace();
                }
                LinkedList<int[]> linkedList = this.queue;
                synchronized (linkedList) {
                    this.running = false;
                    this.queue.notifyAll();
                }
            });
            thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            LinkedList<int[]> linkedList = this.queue;
            synchronized (linkedList) {
                this.running = false;
                this.queue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int[] next() {
            LinkedList<int[]> linkedList = this.queue;
            synchronized (linkedList) {
                try {
                    while (this.queue.isEmpty() && this.running) {
                        this.queue.wait();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.queue.notifyAll();
                if (!this.queue.isEmpty()) {
                    return this.queue.remove(0);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitFor() {
            LinkedList<int[]> linkedList = this.queue;
            synchronized (linkedList) {
                try {
                    while (this.running) {
                        this.queue.wait();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

