/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.fsm;

import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.parser.ParseException;
import de.neemann.digital.analyse.parser.Parser;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.graphics.VectorFloat;
import de.neemann.digital.draw.graphics.VectorInterface;
import de.neemann.digital.fsm.FiniteStateMachineException;
import de.neemann.digital.fsm.Movable;
import de.neemann.digital.fsm.State;
import de.neemann.digital.lang.Lang;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Transition
extends Movable<Transition> {
    private static final float EXPANSION_TRANS = 0.001f;
    private final State fromState;
    private final State toState;
    private String condition;
    private transient Expression conditionExpression;

    public Transition(State fromState, State toState, String condition) {
        this.fromState = fromState;
        this.toState = toState;
        this.condition = condition == null ? "" : condition;
        this.initPos();
    }

    Transition(Transition other, ArrayList<State> states, List<State> otherStates) {
        this.condition = other.condition;
        this.fromState = states.get(otherStates.indexOf(other.fromState));
        this.toState = states.get(otherStates.indexOf(other.toState));
        this.setValues(other.getValues());
        this.setPos(other.getPos());
    }

    void calcForce(List<State> states, List<Transition> transitions) {
        float preferredDist = Math.max(this.fromState.getVisualRadius(), this.toState.getVisualRadius());
        this.calcForce(preferredDist * 5.0f, states, transitions);
    }

    void calcForce(float preferredDist, List<State> states, List<Transition> transitions) {
        if (this.fromState != this.toState) {
            VectorFloat dir = this.fromState.getPos().sub(this.toState.getPos());
            float len = dir.len();
            float d = len - preferredDist;
            dir = dir.mul(0.001f * d);
            this.toState.addToForce(dir);
            this.fromState.addToForce(dir.mul(-1.0f));
        }
        this.resetForce();
        VectorFloat center = this.fromState.getPos().add(this.toState.getPos()).mul(0.5f);
        this.addAttractiveTo(center, 1.0f);
        for (State s : states) {
            if (s == this.fromState != (s == this.toState)) continue;
            this.addRepulsive(s.getPos(), 2000.0f);
        }
        for (Transition t : transitions) {
            if (t == this) continue;
            this.addRepulsive(t.getPos(), 1500.0f);
        }
    }

    @Override
    public void setPosDragging(VectorFloat position) {
        super.setPosDragging(this.posConstrain(position));
    }

    @Override
    public void setPos(VectorFloat position) {
        super.setPos(this.posConstrain(position));
    }

    private VectorFloat posConstrain(VectorFloat position) {
        VectorFloat dist;
        if (this.fromState != this.toState && ((dist = this.toState.getPos().sub(this.fromState.getPos())).getXFloat() != 0.0f || dist.getYFloat() != 0.0f)) {
            dist = dist.norm();
            VectorFloat start = this.fromState.getPos().add(dist.mul(this.fromState.getVisualRadius()));
            VectorFloat end = this.toState.getPos().sub(dist.mul(this.toState.getVisualRadius()));
            VectorFloat p = position.sub(start);
            VectorFloat n = dist.getOrthogonal();
            float l = p.mul(n);
            return start.add(end).div(2).add(n.mul(l));
        }
        return position;
    }

    public void drawTo(Graphic gr) {
        VectorFloat anchor;
        VectorFloat anchor0;
        VectorFloat end;
        VectorFloat start;
        Style style = Style.SHAPE_PIN;
        if (this.getFsm() != null && this.getFsm().getActiveTransition() == this) {
            style = Style.HIGHLIGHT;
        }
        if (this.fromState == this.toState) {
            VectorFloat dif = this.getPos().sub(this.fromState.getPos()).getOrthogonal().mul(0.5f);
            VectorFloat ps = this.getPos().add(dif);
            VectorFloat pe = this.getPos().sub(dif);
            start = this.fromState.getPos().add(ps.sub(this.fromState.getPos()).norm().mul(this.fromState.getVisualRadius() + 4));
            end = this.toState.getPos().add(pe.sub(this.toState.getPos()).norm().mul(this.toState.getVisualRadius() + 4 + 2));
            VectorFloat d0 = start.sub(this.fromState.getPos());
            VectorFloat d3 = end.sub(this.toState.getPos());
            float t = Math.abs(d0.getXFloat() + d3.getXFloat()) > Math.abs(d0.getYFloat() + d3.getYFloat()) ? -4.0f * (start.getXFloat() + end.getXFloat() - 2.0f * this.getPos().getXFloat()) / (3.0f * (d0.getXFloat() + d3.getXFloat())) : -4.0f * (start.getYFloat() + end.getYFloat() - 2.0f * this.getPos().getYFloat()) / (3.0f * (d0.getYFloat() + d3.getYFloat()));
            anchor0 = start.add(d0.mul(t));
            anchor = end.add(d3.mul(t));
        } else {
            float n = 1.75f;
            VectorFloat correctedPos = this.getPos().mul(n).add(this.fromState.getPos().add(this.toState.getPos()).mul((1.0f - n) / 2.0f));
            start = this.fromState.getPos().add(correctedPos.sub(this.fromState.getPos()).norm().mul(this.fromState.getVisualRadius() + 4));
            end = this.toState.getPos().add(correctedPos.sub(this.toState.getPos()).norm().mul(this.toState.getVisualRadius() + 4 + 2));
            anchor = this.getPos().mul(2.0f).sub(start.div(2)).sub(end.div(2));
            anchor0 = null;
        }
        Transition.drawArrow(gr, start, anchor0, anchor, end, style);
        ArrayList<String> strings = new ArrayList<String>();
        if (this.condition != null && !this.condition.isEmpty()) {
            strings.add("$" + this.condition + "$");
        }
        if (this.getValues() != null && !this.getValues().isEmpty()) {
            strings.add(Lang.get("fsm_set_N", "$" + this.getValues() + "$"));
        }
        if (!strings.isEmpty()) {
            int fontSize = Style.NORMAL.getFontSize();
            VectorFloat textPos = this.getPos().add(0.0f, (float)(-fontSize * (strings.size() - 1)) / 2.0f);
            if (this.fromState.getPos().getYFloat() < this.getPos().getYFloat() && this.toState.getPos().getYFloat() < this.getPos().getYFloat()) {
                textPos = textPos.add(new VectorFloat(0.0f, (float)(fontSize * strings.size()) / 2.0f));
            }
            if (this.fromState.getPos().getYFloat() > this.getPos().getYFloat() && this.toState.getPos().getYFloat() > this.getPos().getYFloat()) {
                textPos = textPos.add(new VectorFloat(0.0f, (float)(-fontSize * strings.size()) / 2.0f));
            }
            for (String s : strings) {
                gr.drawText(textPos, s, Orientation.CENTERCENTER, Style.NORMAL);
                textPos = textPos.add(0.0f, fontSize);
            }
        }
    }

    static void drawArrow(Graphic gr, VectorInterface start, VectorInterface anchor0, VectorInterface anchor, VectorInterface end, Style arrowStyle) {
        if (anchor == null) {
            anchor = start.add(end).div(2);
        }
        if (anchor0 != null) {
            gr.drawPolygon(new Polygon(false).add(start).add(anchor0, anchor, end), arrowStyle);
        } else {
            gr.drawPolygon(new Polygon(false).add(start).add(anchor, end), arrowStyle);
        }
        VectorFloat dir = anchor.sub(end).norm().mul(20.0f);
        VectorFloat lot = dir.getOrthogonal().mul(0.3f);
        gr.drawPolygon(new Polygon(false).add(end.add(dir).add(lot)).add(end.sub(dir.mul(0.1f))).add(end.add(dir).sub(lot)), arrowStyle);
    }

    void initPos() {
        this.setPos(this.fromState.getPos().add(this.toState.getPos()).mul(0.5f).add(new VectorFloat((float)Math.random() - 0.5f, (float)Math.random() - 0.5f).mul(2.0f)));
    }

    public void setCondition(String condition) {
        if (!this.condition.equals(condition)) {
            this.condition = condition;
            this.wasModified(Movable.Property.CONDITION);
            this.conditionExpression = null;
        }
    }

    public String getCondition() {
        return this.condition;
    }

    Expression getConditionExpression() throws FiniteStateMachineException {
        if (this.conditionExpression == null && this.condition != null && this.condition.trim().length() > 0) {
            try {
                ArrayList<Expression> ex = new Parser(this.condition).parse();
                if (ex.size() != 1) {
                    throw new FiniteStateMachineException(Lang.get("err_fsmErrorInCondition_N", this.condition));
                }
                this.conditionExpression = ex.get(0);
            }
            catch (ParseException | IOException e) {
                throw new FiniteStateMachineException(Lang.get("err_fsmErrorInCondition_N", this.condition), e);
            }
        }
        return this.conditionExpression;
    }

    boolean hasCondition() throws FiniteStateMachineException {
        return this.getConditionExpression() != null;
    }

    State getStartState() {
        return this.fromState;
    }

    State getTargetState() {
        return this.toState;
    }

    public boolean matches(Vector pos) {
        return pos.sub(this.getPos()).len() < 50.0f;
    }

    public String toString() {
        return this.fromState + " --[" + this.condition + "]-> " + this.toState;
    }
}

