/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components;

import de.neemann.digital.core.element.Keys;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.Movable;
import de.neemann.digital.draw.elements.VisualElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;

public class CopiedElementLabelRenamer {
    private final ArrayList<Movable> elements;

    CopiedElementLabelRenamer(Circuit circuit, ArrayList<Movable> elements) {
        this.elements = elements;
        HashMap<LabelClass, PresentIndex> circuitMap = new HashMap<LabelClass, PresentIndex>();
        for (VisualElement ve : circuit.getElements()) {
            LabelInstance li = LabelInstance.create(ve);
            if (li == null) continue;
            PresentIndex pi = circuitMap.computeIfAbsent(li.getLabelClass(), labelClass -> new PresentIndex());
            pi.add(li.getNumber());
        }
        HashMap<LabelClass, MinIndex> insertMap = new HashMap<LabelClass, MinIndex>();
        for (Movable m : elements) {
            LabelInstance li;
            if (!(m instanceof VisualElement) || (li = LabelInstance.create((VisualElement)m)) == null) continue;
            MinIndex mi = (MinIndex)insertMap.get(li.getLabelClass());
            if (mi == null) {
                mi = new MinIndex(li.getNumber());
                insertMap.put(li.getLabelClass(), mi);
                continue;
            }
            mi.checkMin(li.getNumber());
        }
        for (Movable m : elements) {
            PresentIndex pi;
            LabelInstance li;
            VisualElement ve;
            if (!(m instanceof VisualElement) || !(ve = (VisualElement)m).getElementAttributes().get(Keys.PINNUMBER).isEmpty() || (li = LabelInstance.create(ve)) == null || (pi = (PresentIndex)circuitMap.get(li.getLabelClass())) == null || !pi.contains(li.getNumber())) continue;
            int maxAvail = pi.getMax();
            int minToInsert = ((MinIndex)insertMap.get(li.getLabelClass())).getMin();
            int delta = maxAvail - minToInsert + 1;
            ve.setAttribute(Keys.LABEL, li.getLabel(delta));
        }
    }

    public ArrayList<Movable> rename() {
        return this.elements;
    }

    static final class LabelClass {
        private final String elementName;
        private final String label;

        private LabelClass(String elementName, String label) {
            this.elementName = elementName;
            this.label = label;
        }

        public String getElementName() {
            return this.elementName;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LabelClass that = (LabelClass)o;
            return Objects.equals(this.elementName, that.elementName) && Objects.equals(this.label, that.label);
        }

        public int hashCode() {
            return Objects.hash(this.elementName, this.label);
        }
    }

    static final class LabelInstance {
        private final LabelClass lc;
        private final int number;

        static LabelInstance create(VisualElement ve) {
            return LabelInstance.create(ve.getElementName(), ve.getElementAttributes().getLabel());
        }

        static LabelInstance create(String elementName, String fullLabel) {
            if (fullLabel == null) {
                return null;
            }
            int pos = fullLabel.length();
            if (pos == 0) {
                return null;
            }
            if (!Character.isDigit(fullLabel.charAt(pos - 1))) {
                return null;
            }
            int number = 0;
            int base = 1;
            while (pos > 0 && Character.isDigit(fullLabel.charAt(pos - 1))) {
                number += (fullLabel.charAt(--pos) - 48) * base;
                base *= 10;
            }
            String label = fullLabel.substring(0, pos);
            LabelClass lc = new LabelClass(elementName, label);
            return new LabelInstance(lc, number);
        }

        private LabelInstance(LabelClass lc, int number) {
            this.lc = lc;
            this.number = number;
        }

        LabelClass getLabelClass() {
            return this.lc;
        }

        public int getNumber() {
            return this.number;
        }

        public String getLabel(int delta) {
            return String.valueOf(this.lc.label) + Integer.toString(this.number + delta);
        }
    }

    private static final class MinIndex {
        private int min;

        private MinIndex(int number) {
            this.min = number;
        }

        void checkMin(int number) {
            if (this.min > number) {
                this.min = number;
            }
        }

        public int getMin() {
            return this.min;
        }
    }

    private static final class PresentIndex {
        private HashSet<Integer> numbers;
        private int max = Integer.MIN_VALUE;

        private PresentIndex() {
            this.numbers = new HashSet();
        }

        public void add(int number) {
            this.numbers.add(number);
            if (number > this.max) {
                this.max = number;
            }
        }

        public boolean contains(int number) {
            return this.numbers.contains(number);
        }

        public int getMax() {
            return this.max;
        }
    }
}

