/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components;

import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Key;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.shapes.ShapeFactory;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.ErrorMessage;
import de.neemann.gui.Screen;
import de.neemann.gui.ToolTipAction;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;

public class ElementHelpDialog
extends JDialog {
    private static final int IMAGE_SCALE = 2;
    private static final int MAX_WIDTH = 600;
    private static final int MAX_HEIGHT = 800;
    private final boolean showKeys;
    private JPanel buttons;

    public ElementHelpDialog(Window parent, ElementTypeDescription elementType, ElementAttributes elementAttributes) throws NodeException, PinException {
        this(parent, elementType, elementAttributes, false);
    }

    public ElementHelpDialog(Window parent, ElementTypeDescription elementType, ElementAttributes elementAttributes, boolean showKeys) throws NodeException, PinException {
        super(parent, Lang.get("attr_help", new Object[0]), Dialog.ModalityType.MODELESS);
        this.showKeys = showKeys;
        this.setDefaultCloseOperation(2);
        StringWriter w = new StringWriter();
        try {
            this.writeDetailedDescription(w, elementType, elementAttributes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.init(parent, w.toString());
    }

    public ElementHelpDialog(JFrame parent, final ElementLibrary library, ShapeFactory shapeFactory) throws NodeException, PinException {
        super(parent, Lang.get("attr_help", new Object[0]), true);
        this.showKeys = false;
        this.setDefaultCloseOperation(2);
        MyURLStreamHandlerFactory.setShapeFactory(shapeFactory);
        StringWriter w = new StringWriter();
        try {
            w.write("<html><body>");
            this.writeFullHTMLDocumentation(w, library, description -> "image:" + description.getName() + ".png");
            w.write("</body></html>");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.init(parent, w.toString());
        this.buttons.add((Component)new ToolTipAction(Lang.get("btn_openInBrowser", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    File tmp = Files.createTempDirectory("digital", new FileAttribute[0]).toFile();
                    ElementHelpDialog.this.exportHTMLDocumentation(tmp, library);
                    File index = new File(tmp, "index.html");
                    ElementHelpDialog.openWebpage(index.toURI());
                }
                catch (NodeException | PinException | IOException e) {
                    new ErrorMessage(Lang.get("err_openingDocumentation", new Object[0])).addCause(e).show(ElementHelpDialog.this);
                }
            }
        }.setToolTip(Lang.get("btn_openInBrowser_tt", new Object[0])).createJButton(), 0);
    }

    private void init(Component parent, String description) {
        JEditorPane editorPane = new JEditorPane("text/html", description);
        editorPane.setEditable(false);
        editorPane.setCaretPosition(0);
        editorPane.putClientProperty("JEditorPane.honorDisplayProperties", true);
        editorPane.addHyperlinkListener(hyperlinkEvent -> {
            if (HyperlinkEvent.EventType.ACTIVATED == hyperlinkEvent.getEventType()) {
                String desc = hyperlinkEvent.getDescription();
                if (desc == null || !desc.startsWith("#")) {
                    return;
                }
                desc = desc.substring(1);
                editorPane.scrollToReference(desc);
            }
        });
        this.getContentPane().add(new JScrollPane(editorPane));
        this.buttons = new JPanel(new FlowLayout(2));
        this.buttons.add(new JButton(new AbstractAction(Lang.get("ok", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ElementHelpDialog.this.dispose();
            }
        }));
        this.getContentPane().add((Component)this.buttons, "South");
        this.pack();
        Dimension r = this.getSize();
        if (r.width > 600) {
            r.width = 600;
        }
        if (r.height > 800) {
            r.height = 800;
        }
        this.setSize(Screen.getInstance().scale(r));
        this.setLocationRelativeTo(parent);
    }

    private void writeFullHTMLDocumentation(Writer w, ElementLibrary library, ImageHandler imageHandler) throws IOException, NodeException, PinException {
        ArrayList<String> chapter = new ArrayList<String>();
        String actPath = null;
        StringWriter content = new StringWriter();
        int chapNum = 0;
        for (ElementLibrary.ElementContainer e : library) {
            String p = e.getTreePath();
            if (!p.equals(actPath)) {
                actPath = p;
                chapter.add(actPath);
                content.append("<h2>").append(Integer.toString(++chapNum)).append(". <a name=\"").append(actPath).append("\">").append(actPath).append("</a></h2>\n");
                content.append("<hr/>\n");
            }
            String url = imageHandler.getUrl(e.getDescription());
            BufferedImage bi = MyURLStreamHandlerFactory.getImage(e.getDescription().getName());
            content.append("<center><img src=\"").append(url).append("\" width=\"").append(Integer.toString(bi.getWidth() / 2)).append("\" height=\"").append(Integer.toString(bi.getHeight() / 2)).append("\"/></center>\n");
            this.writeHTMLDescription(content, e.getDescription(), new ElementAttributes());
            content.append("<hr/>\n");
        }
        content.flush();
        w.append("<h1>").append(Lang.get("digital", new Object[0])).append("</h1>\n");
        w.append("<h2>").append(Lang.get("tableOfContent", new Object[0])).append("</h2>\n");
        chapNum = 0;
        for (String chap : chapter) {
            w.append(Integer.toString(++chapNum)).append(". <a href=\"#").append(chap).append("\">").append(chap).append("</a><br/>\n");
        }
        w.write(content.toString());
    }

    private void writeDetailedDescription(Writer w, ElementTypeDescription et, ElementAttributes elementAttributes) throws IOException, NodeException, PinException {
        w.write("<html><body>");
        this.writeHTMLDescription(w, et, elementAttributes);
        w.write("</body></html>");
    }

    private void writeHTMLDescription(Writer w, ElementTypeDescription et, ElementAttributes elementAttributes) throws IOException, NodeException, PinException {
        PinDescriptions outputs;
        PinDescriptions inputs;
        String translatedName = et.getTranslatedName();
        if (translatedName.endsWith(".dig")) {
            translatedName = new File(translatedName).getName();
        }
        w.append("<h3>").append(ElementHelpDialog.escapeHTML(translatedName)).append("</h3>\n");
        String descr = et.getDescription(elementAttributes);
        if (this.showKeys) {
            descr = String.valueOf(descr) + " (" + Lang.get("msg_keyAsGenericAttribute", et.getName()) + ")";
        }
        if (!descr.equals(translatedName)) {
            w.append("<p>").append(ElementHelpDialog.escapeHTML(descr)).append("</p>\n");
        }
        if ((inputs = et.getInputDescription(elementAttributes)) != null && inputs.size() > 0) {
            w.append("<h4>").append(Lang.get("elem_Help_inputs", new Object[0])).append(":</h4>\n<dl>\n");
            for (PinDescription i : inputs) {
                this.writeEntry(w, i.getName(), i.getDescription());
            }
            w.append("</dl>\n");
        }
        if ((outputs = et.getOutputDescriptions(elementAttributes)) != null && outputs.size() > 0) {
            w.append("<h4>").append(Lang.get("elem_Help_outputs", new Object[0])).append(":</h4>\n<dl>\n");
            for (PinDescription i : outputs) {
                String description = i.getDescription();
                this.writeEntry(w, i.getName(), description);
            }
            w.append("</dl>\n");
        }
        if (et.getAttributeList().size() > 0) {
            w.append("<h4>").append(Lang.get("elem_Help_attributes", new Object[0])).append(":</h4>\n<dl>\n");
            for (Key k : et.getAttributeList()) {
                if (k.isSecondary()) continue;
                this.writeEntry(w, k);
            }
            for (Key k : et.getAttributeList()) {
                if (!k.isSecondary()) continue;
                this.writeEntry(w, k);
            }
            w.append("</dl>\n");
        }
    }

    private void writeEntry(Writer w, String name, String description) throws IOException {
        w.append("<dt><i>").append(ElementHelpDialog.escapeHTML(name)).append("</i></dt>\n");
        if (description != null && description.length() > 0 && !name.equals(description)) {
            w.append("<dd>").append(ElementHelpDialog.escapeHTML(description)).append("</dd>\n");
        }
    }

    private void writeEntry(Writer w, Key<?> key) throws IOException {
        String name = key.getName();
        String description = key.getDescription();
        w.append("<dt><i>").append(ElementHelpDialog.escapeHTML(name)).append("</i></dt>\n");
        if (description != null && description.length() > 0 && !name.equals(description)) {
            w.append("<dd>").append(ElementHelpDialog.escapeHTML(description));
            if (this.showKeys) {
                String keyName = key.getKey();
                if (keyName.contains(" ")) {
                    keyName = "'" + keyName + "'";
                }
                w.append(" (").append(Lang.get("msg_keyAsGenericAttribute", keyName)).append(')');
            }
            w.append("</dd>\n");
        }
    }

    public static URLStreamHandlerFactory createURLStreamHandlerFactory() {
        return new MyURLStreamHandlerFactory();
    }

    private void exportHTMLDocumentation(File targetPath, ElementLibrary library) throws IOException, NodeException, PinException {
        File images = new File(targetPath, "img");
        if (!images.mkdir()) {
            throw new IOException("could not create image folder " + images);
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(targetPath, "index.html")), StandardCharsets.UTF_8));){
            w.write("<!DOCTYPE html>\n<html>\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html\" charset=\"utf-8\"/>\n</head>\n<body>\n");
            this.writeFullHTMLDocumentation(w, library, description -> {
                BufferedImage bi = MyURLStreamHandlerFactory.getImage(description.getName());
                String filename = description.getName().replace('\\', '_').replace('/', '_').replace(':', '_');
                ImageIO.write((RenderedImage)bi, "png", new File(images, String.valueOf(filename) + ".png"));
                return "img/" + filename + ".png";
            });
            w.write("</body>\n</html>");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void openWebpage(URI uri) throws IOException {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop == null || !desktop.isSupported(Desktop.Action.BROWSE)) {
            throw new IOException("could not open browser");
        }
        desktop.browse(uri);
    }

    private static String escapeHTML(String text) {
        StringBuilder sb = new StringBuilder(text.length() * 2);
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private static class ImageConnection
    extends URLConnection {
        ImageConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            String path = this.url.getPath();
            if (path.endsWith(".png")) {
                path = path.substring(0, path.length() - 4);
            }
            BufferedImage bi = MyURLStreamHandlerFactory.getImage(path);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, "png", baos);
            return new ByteArrayInputStream(baos.toByteArray());
        }
    }

    private static interface ImageHandler {
        public String getUrl(ElementTypeDescription var1) throws IOException, PinException, NodeException;
    }

    private static class MyURLStreamHandlerFactory
    implements URLStreamHandlerFactory {
        private static final HashMap<String, BufferedImage> IMAGE_MAP = new HashMap();
        private static ShapeFactory shapeFactory;

        private MyURLStreamHandlerFactory() {
        }

        public static void setShapeFactory(ShapeFactory shapeFactory) {
            MyURLStreamHandlerFactory.shapeFactory = shapeFactory;
            IMAGE_MAP.clear();
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            if (protocol.equals("image")) {
                return new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL u) {
                        return new ImageConnection(u);
                    }
                };
            }
            return null;
        }

        static BufferedImage getImage(String name) {
            BufferedImage bi = IMAGE_MAP.get(name);
            if (bi == null) {
                float scale = 2.0f * Screen.getInstance().getScaling();
                bi = new VisualElement(name).setShapeFactory(shapeFactory).getBufferedImage(0.75 * (double)scale, (int)(250.0f * scale));
                IMAGE_MAP.put(name, bi);
            }
            return bi;
        }
    }
}

