/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components;

import de.neemann.digital.lang.Lang;
import de.neemann.gui.Screen;
import de.neemann.gui.ToolTipAction;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ElementOrderer<T>
extends JDialog {
    private final JPanel buttons;
    private final JList<T> list;
    private final MyListModel<T> listModel;
    private final OrderInterface<T> data;
    private boolean okPressed = true;

    public ElementOrderer(Window owner, String title, final OrderInterface<T> data) {
        super(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.data = data;
        this.setDefaultCloseOperation(2);
        this.listModel = new MyListModel<T>(data);
        this.list = new JList<T>(this.listModel);
        this.list.setSelectionMode(1);
        JScrollPane scrollPane = new JScrollPane(this.list);
        this.getContentPane().add(scrollPane);
        scrollPane.setPreferredSize(Screen.getInstance().scale(new Dimension(100, 150)));
        this.buttons = new JPanel();
        this.buttons.setLayout(new BoxLayout(this.buttons, 1));
        this.buttons.add(new ToolTipAction("\u2191"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i0 = ElementOrderer.this.list.getSelectionModel().getMinSelectionIndex();
                int i1 = ElementOrderer.this.list.getSelectionModel().getMaxSelectionIndex();
                if (i0 > 0 && i1 > 0) {
                    int i = i0;
                    while (i <= i1) {
                        ElementOrderer.this.listModel.swap(i, i - 1);
                        ++i;
                    }
                    ElementOrderer.this.list.getSelectionModel().setSelectionInterval(i0 - 1, i1 - 1);
                }
            }
        }.setToolTip(Lang.get("tt_moveItemUp", new Object[0])).createJButton());
        this.buttons.add(new ToolTipAction("\u2193"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i0 = ElementOrderer.this.list.getSelectionModel().getMinSelectionIndex();
                int i1 = ElementOrderer.this.list.getSelectionModel().getMaxSelectionIndex();
                if (i0 >= 0 && i0 < data.size() - 1 && i1 >= 0 && i1 < data.size() - 1) {
                    int i = i1;
                    while (i >= i0) {
                        ElementOrderer.this.listModel.swap(i, i + 1);
                        --i;
                    }
                    ElementOrderer.this.list.getSelectionModel().setSelectionInterval(i0 + 1, i1 + 1);
                }
            }
        }.setToolTip(Lang.get("tt_moveItemDown", new Object[0])).createJButton());
        this.getContentPane().add((Component)this.buttons, "East");
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    public ElementOrderer<T> addOkButton() {
        JButton okButton = new JButton(new AbstractAction(Lang.get("ok", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                ElementOrderer.this.okPressed = true;
                ElementOrderer.this.dispose();
            }
        });
        this.getContentPane().add((Component)okButton, "South");
        this.okPressed = false;
        return this;
    }

    public ElementOrderer<T> addDeleteButton(final int minEntries) {
        this.buttons.add(new ToolTipAction("\u2717"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i0 = ElementOrderer.this.list.getSelectionModel().getMinSelectionIndex();
                int i1 = ElementOrderer.this.list.getSelectionModel().getMaxSelectionIndex();
                int del = i1 - i0 + 1;
                if (ElementOrderer.this.data.size() - del >= minEntries && del > 0) {
                    int i = i1;
                    while (i >= i0) {
                        ElementOrderer.this.listModel.delete(i);
                        --i;
                    }
                }
                if (ElementOrderer.this.data.size() <= minEntries) {
                    this.setEnabled(false);
                }
            }
        }.setToolTip(Lang.get("tt_deleteItem", new Object[0])).setEnabledChain(this.data.size() > minEntries).createJButton());
        return this;
    }

    public boolean showDialog() {
        this.pack();
        this.setVisible(true);
        return this.okPressed;
    }

    public static class ListOrder<T>
    implements OrderInterface<T> {
        private List<T> list;

        public ListOrder(List<T> list) {
            this.list = list;
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public T get(int index) {
            return this.list.get(index);
        }

        @Override
        public void swap(int i, int j) {
            T z = this.list.get(i);
            this.list.set(i, this.list.get(j));
            this.list.set(j, z);
        }

        @Override
        public void delete(int index) {
            this.list.remove(index);
        }
    }

    private class MyListModel<T>
    implements ListModel<T> {
        private final OrderInterface<T> data;
        private ArrayList<ListDataListener> listener;

        MyListModel(OrderInterface<T> data) {
            this.data = data;
            this.listener = new ArrayList();
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public T getElementAt(int index) {
            return this.data.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listener.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listener.remove(l);
        }

        void swap(int i, int j) {
            this.data.swap(i, j);
            this.fireEvent(Math.min(i, j), Math.max(i, j));
        }

        void delete(int i) {
            this.data.delete(i);
            this.fireEventDeleted(i);
        }

        private void fireEvent(int min, int max) {
            ListDataEvent e = new ListDataEvent(this, 0, min, max);
            for (ListDataListener l : this.listener) {
                l.contentsChanged(e);
            }
        }

        private void fireEventDeleted(int item) {
            ListDataEvent e = new ListDataEvent(this, 2, item, item);
            for (ListDataListener l : this.listener) {
                l.contentsChanged(e);
            }
        }
    }

    public static interface OrderInterface<T> {
        public int size();

        public T get(int var1);

        public void swap(int var1, int var2);

        default public void delete(int index) {
            throw new UnsupportedOperationException("delete");
        }
    }
}

