/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.expression;

import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.format.FormatToExpression;
import de.neemann.digital.analyse.parser.Parser;
import de.neemann.digital.builder.circuit.CircuitBuilder;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.shapes.ShapeFactory;
import de.neemann.digital.gui.Main;
import de.neemann.digital.gui.components.EditorFactory;
import de.neemann.digital.gui.components.table.ShowStringDialog;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.ErrorMessage;
import de.neemann.gui.ToolTipAction;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ExpressionDialog
extends JDialog {
    public ExpressionDialog(final Main parent, final ElementLibrary library, final ShapeFactory shapeFactory, final File baseFilename) {
        super(parent, Lang.get("expression", new Object[0]), false);
        String exampleEquation = "(C \u2228 B) \u2227 (A \u2228 C) \u2227 (B \u2228 !C) * (C + !A)";
        final JTextArea text = EditorFactory.addF1Traversal(new JTextArea(exampleEquation, 5, 40));
        this.getContentPane().add((Component)new JScrollPane(text), "Center");
        this.getContentPane().add((Component)new JLabel(Lang.get("msg_enterAnExpression", new Object[0])), "North");
        JPanel buttons = new JPanel(new FlowLayout(2));
        this.getContentPane().add((Component)buttons, "South");
        buttons.add(new ToolTipAction(Lang.get("btn_help", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ShowStringDialog((Window)ExpressionDialog.this, Lang.get("msg_expressionHelpTitle", new Object[0]), Lang.get("msg_expressionHelp", new Object[0]), true).setVisible(true);
            }
        }.createJButton());
        buttons.add(new ToolTipAction(Lang.get("btn_create", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ArrayList<Expression> expList = new Parser(text.getText()).parse();
                    CircuitBuilder circuitBuilder = new CircuitBuilder(shapeFactory).setResolveLocalVars(true);
                    if (expList.size() == 1) {
                        circuitBuilder.addCombinatorial("Y", expList.get(0));
                    } else {
                        for (Expression exp : expList) {
                            circuitBuilder.addCombinatorial(FormatToExpression.defaultFormat(exp), exp);
                        }
                    }
                    Circuit circuit = circuitBuilder.createCircuit();
                    new Main.MainBuilder().setParent(parent).setLibrary(library).setCircuit(circuit).setBaseFileName(baseFilename).openLater();
                }
                catch (Exception ex) {
                    new ErrorMessage().addCause(ex).show(ExpressionDialog.this);
                }
            }
        }.setToolTip(Lang.get("btn_create_tt", new Object[0])).createJButton());
        this.pack();
        this.setLocationRelativeTo(parent);
    }
}

