/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.modification;

import de.neemann.digital.core.element.Keys;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.undo.Modification;
import de.neemann.digital.undo.ModifyException;

public abstract class ModificationOfVisualElement
implements Modification<Circuit> {
    private final Vector pos;
    private final String description;
    private final String name;

    ModificationOfVisualElement(VisualElement ve, String description) {
        this.name = ve.getElementName();
        this.pos = ve.getPos();
        this.description = description;
    }

    public static String getToolTipName(VisualElement ve) {
        String l;
        String s = Lang.getNull("elem_" + ve.getElementName(), new Object[0]);
        if (s == null && (s = ve.getElementName()).endsWith(".dig")) {
            s = s.substring(0, s.length() - 4);
        }
        if ((l = ve.getElementAttributes().get(Keys.LABEL)).length() > 0) {
            s = String.valueOf(s) + " (" + l + ")";
        }
        return s;
    }

    public String toString() {
        return this.description;
    }

    public VisualElement getVisualElement(Circuit circuit) throws ModifyException {
        for (VisualElement ve : circuit.getElements()) {
            if (!ve.getPos().equals(this.pos) || !ve.getElementName().equals(this.name)) continue;
            return ve;
        }
        throw new ModifyException("internal error: Element not found!");
    }
}

