/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.table;

import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.Not;
import de.neemann.digital.analyse.expression.Operation;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.expression.VariableVisitor;
import de.neemann.digital.analyse.expression.format.FormatterException;
import de.neemann.digital.gui.components.table.ExpressionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class ExpressionListenerCSVCondensed
implements ExpressionListener {
    private final ArrayList<Result> results = new ArrayList();
    private final HashSet<String> names = new HashSet();
    private final VariableVisitor variables = new VariableVisitor();
    private StringBuilder str;

    @Override
    public void resultFound(String name, Expression expression) throws FormatterException, ExpressionException {
        if (!this.names.contains(name)) {
            this.names.add(name);
            this.results.add(new Result(name, expression, this.results.size()));
            expression.traverse(this.variables);
        }
    }

    @Override
    public void close() throws FormatterException, ExpressionException {
        this.str = new StringBuilder();
        for (Variable var : this.variables.getVariables()) {
            this.str.append(var.getIdentifier()).append(",");
        }
        for (Result r : this.results) {
            this.str.append(",").append(r.name);
        }
        this.str.append("\n");
        for (Result r : this.results) {
            r.createString(this.str, this.variables.getVariables(), this.results.size());
        }
    }

    public String toString() {
        return this.str.toString();
    }

    private static final class Result {
        private final String name;
        private final Expression expression;
        private final int number;

        private Result(String name, Expression expression, int number) {
            this.name = name;
            this.expression = expression;
            this.number = number;
        }

        public void createString(StringBuilder sb, Collection<Variable> variables, int results) throws ExpressionException {
            if (this.expression instanceof Operation.Or) {
                ArrayList<Expression> o = ((Operation.Or)this.expression).getExpressions();
                for (Expression e : o) {
                    this.addPrime(sb, e, variables, results);
                }
            } else {
                this.addPrime(sb, this.expression, variables, results);
            }
        }

        private void addPrime(StringBuilder sb, Expression and, Collection<Variable> variables, int results) throws ExpressionException {
            if (and instanceof Operation.And) {
                this.addAnd(sb, and, variables, results);
            } else if (and instanceof Variable) {
                this.addVar(sb, ((Variable)and).getIdentifier(), variables, results, false);
            } else if (and instanceof Not && ((Not)and).getExpression() instanceof Variable) {
                this.addVar(sb, ((Variable)((Not)and).getExpression()).getIdentifier(), variables, results, true);
            } else {
                throw new ExpressionException("invalid expression");
            }
        }

        private void addVar(StringBuilder sb, String identifier, Collection<Variable> variables, int results, boolean invert) {
            for (Variable var : variables) {
                if (var.getIdentifier().endsWith(identifier)) {
                    if (invert) {
                        sb.append("0,");
                        continue;
                    }
                    sb.append("1,");
                    continue;
                }
                sb.append("X,");
            }
            int i = 0;
            while (i < results) {
                if (i == this.number) {
                    sb.append(",1");
                } else {
                    sb.append(",0");
                }
                ++i;
            }
            sb.append('\n');
        }

        private void addAnd(StringBuilder sb, Expression and, Collection<Variable> variables, int results) throws ExpressionException {
            HashSet<String> v = new HashSet<String>();
            HashSet nv = new HashSet();
            if (and instanceof Operation.And) {
                Operation.And a = (Operation.And)and;
                Iterator<Expression> iterator = a.getExpressions().iterator();
                while (iterator.hasNext()) {
                    Expression va;
                    Expression var = va = iterator.next();
                    HashSet<String> map = v;
                    if (var instanceof Not) {
                        map = nv;
                        var = ((Not)var).getExpression();
                    }
                    if (var instanceof Variable) {
                        map.add(((Variable)var).getIdentifier());
                        continue;
                    }
                    throw new ExpressionException("invalid expression");
                }
            } else {
                throw new ExpressionException("invalid expression");
            }
            for (Variable var : variables) {
                if (v.contains(var.getIdentifier())) {
                    sb.append("1,");
                    continue;
                }
                if (nv.contains(var.getIdentifier())) {
                    sb.append("0,");
                    continue;
                }
                sb.append("X,");
            }
            int i = 0;
            while (i < results) {
                if (i == this.number) {
                    sb.append(",1");
                } else {
                    sb.append(",0");
                }
                ++i;
            }
            sb.append('\n');
        }
    }
}

