/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.table;

import de.neemann.digital.analyse.DetermineJKStateMachine;
import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.format.FormatterException;
import de.neemann.digital.gui.components.table.ExpressionListener;

public class ExpressionListenerJK
implements ExpressionListener {
    private final ExpressionListener parent;

    public ExpressionListenerJK(ExpressionListener parent) {
        this.parent = parent;
    }

    @Override
    public void resultFound(String name, Expression expression) throws FormatterException, ExpressionException {
        this.parent.resultFound(name, expression);
        String detName = ExpressionListenerJK.isSequentialVar(name);
        if (detName != null) {
            DetermineJKStateMachine jk = new DetermineJKStateMachine(detName, expression);
            detName = detName.endsWith("^n") ? detName.substring(0, detName.length() - 2) : detName.substring(0, detName.length() - 1);
            Expression j = jk.getJ();
            this.parent.resultFound("J_" + detName, j);
            Expression s = jk.getSimplifiedJ();
            if (!s.toString().equals(j.toString())) {
                this.parent.resultFound("", s);
            }
            Expression k = jk.getK();
            this.parent.resultFound("K_" + detName, k);
            s = jk.getSimplifiedK();
            if (!s.toString().equals(k.toString())) {
                this.parent.resultFound("", s);
            }
        }
    }

    public static String isSequentialVar(String name) {
        String detName = null;
        if (name.endsWith("n+1")) {
            detName = name.substring(0, name.length() - 2);
        } else if (name.endsWith("{n+1}")) {
            detName = String.valueOf(name.substring(0, name.length() - 5)) + "n";
        }
        return detName;
    }

    @Override
    public void close() throws FormatterException, ExpressionException {
        this.parent.close();
    }
}

