/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.table;

import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.NamedExpression;
import de.neemann.digital.analyse.expression.format.FormatToExpression;
import de.neemann.digital.analyse.expression.format.FormatterException;
import de.neemann.digital.gui.components.table.ExpressionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ExpressionListenerStore
implements ExpressionListener {
    private final ExpressionListener parent;
    private final ArrayList<Result> results;
    private boolean closed;

    public ExpressionListenerStore(ExpressionListener parent) {
        this.parent = parent;
        this.results = new ArrayList();
        this.closed = false;
    }

    @Override
    public void resultFound(String name, Expression expression) throws FormatterException, ExpressionException {
        this.results.add(new Result(name, expression));
        if (this.parent != null) {
            this.parent.resultFound(name, expression);
        }
    }

    @Override
    public void close() throws FormatterException, ExpressionException {
        this.closed = true;
        if (this.parent != null) {
            this.parent.close();
        }
    }

    public void replayTo(ExpressionListener listener) throws FormatterException, ExpressionException {
        if (!this.closed) {
            throw new ExpressionException("ExpressionListenerStore not closed");
        }
        for (Result r : this.results) {
            listener.resultFound(r.name, r.expression.copy());
        }
    }

    public Expression getFirst() {
        return this.results.get(0).expression.copy();
    }

    public List<Result> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    public static final class Result {
        private final String name;
        private final Expression expression;

        private Result(String name, Expression expression) {
            this.name = name;
            this.expression = expression;
        }

        public String getName() {
            return this.name;
        }

        public Expression getExpression() {
            return this.expression;
        }

        public String toString() {
            return FormatToExpression.defaultFormat(new NamedExpression(this.name, this.expression));
        }
    }
}

