/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.table;

import de.neemann.digital.lang.Lang;
import de.neemann.gui.Screen;
import de.neemann.gui.ToolTipAction;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class ShowStringDialog
extends JDialog {
    public ShowStringDialog(JFrame parent, String title, String str) {
        super((Frame)parent, title);
        this.init(parent, str, false);
    }

    public ShowStringDialog(JDialog parent, String title, String str) {
        this((Window)parent, title, str, false);
    }

    public ShowStringDialog(Window parent, String title, String str, boolean html) {
        super(parent, title, Dialog.ModalityType.MODELESS);
        this.init(parent, str, html);
    }

    private void init(Window parent, final String str, boolean html) {
        JTextComponent textComp;
        this.setDefaultCloseOperation(2);
        if (html) {
            textComp = new JEditorPane("text/html", str);
            textComp.setCaretPosition(0);
            textComp.putClientProperty("JEditorPane.honorDisplayProperties", true);
            textComp.setPreferredSize(Screen.getInstance().scale(new Dimension(600, 800)));
        } else {
            textComp = new JTextArea(str);
            textComp.setFont(new JLabel().getFont());
        }
        textComp.setEditable(false);
        textComp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(new JScrollPane(textComp));
        JPanel buttons = new JPanel(new FlowLayout(2));
        if (!html) {
            buttons.add(new ToolTipAction(Lang.get("btn_copyToClipboard", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StringSelection stringSelection = new StringSelection(str);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, null);
                }
            }.setToolTip(Lang.get("btn_copyToClipboard_tt", new Object[0])).createJButton());
        }
        buttons.add(new ToolTipAction(Lang.get("ok", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShowStringDialog.this.dispose();
            }
        }.createJButton());
        this.getContentPane().add((Component)buttons, "South");
        this.pack();
        this.setLocationRelativeTo(parent);
    }
}

