/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.table.hardware;

import de.neemann.digital.analyse.ModelAnalyserInfo;
import de.neemann.digital.analyse.TruthTable;
import de.neemann.digital.analyse.expression.modify.ExpressionModifier;
import de.neemann.digital.builder.ExpressionToFileExporter;
import de.neemann.digital.gui.SaveAsHelper;
import de.neemann.digital.gui.components.table.BuilderExpressionCreator;
import de.neemann.digital.gui.components.table.ExpressionListenerStore;
import de.neemann.digital.gui.components.table.hardware.HardwareDescriptionGenerator;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.LineBreaker;
import de.neemann.gui.MyFileChooser;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class GenerateFile
implements HardwareDescriptionGenerator {
    private final String suffix;
    private final String path;
    private final String description;
    private final ExpressionToFileExporterFactory factory;

    public GenerateFile(String suffix, ExpressionToFileExporterFactory factory, String path, String description) {
        this.suffix = suffix;
        this.path = path;
        this.description = description;
        this.factory = factory;
    }

    @Override
    public String getMenuPath() {
        return this.path;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void generate(JDialog parent, File circuitFile, TruthTable table, ExpressionListenerStore expressions) throws Exception {
        int res;
        ModelAnalyserInfo mai = table.getModelAnalyzerInfo();
        if (mai == null) {
            JOptionPane.showMessageDialog(parent, new LineBreaker().toHTML().breakLines(Lang.get("msg_circuitIsRequired", new Object[0])), Lang.get("msg_warning", new Object[0]), 2);
            return;
        }
        ArrayList<String> pinsWithoutNumber = mai.getPinsWithoutNumber();
        if (!pinsWithoutNumber.isEmpty() && (res = JOptionPane.showConfirmDialog(parent, new LineBreaker().toHTML().breakLines(Lang.get("msg_thereAreMissingPinNumbers", pinsWithoutNumber)), Lang.get("msg_warning", new Object[0]), 2, 2)) != 0) {
            return;
        }
        circuitFile = circuitFile == null ? new File("circuit." + this.suffix) : SaveAsHelper.checkSuffix(circuitFile, this.suffix);
        MyFileChooser fileChooser = new MyFileChooser();
        fileChooser.setFileFilter(new FileNameExtensionFilter("JEDEC", this.suffix));
        fileChooser.setSelectedFile(circuitFile);
        if (fileChooser.showSaveDialog(parent) == 0) {
            ExpressionToFileExporter expressionExporter = this.factory.create();
            expressionExporter.getPinMapping().addAll(mai.getPins());
            expressionExporter.getPinMapping().setClockPin(mai.getClockPinInt());
            new BuilderExpressionCreator(expressionExporter.getBuilder(), ExpressionModifier.IDENTITY).create(expressions);
            expressionExporter.export(SaveAsHelper.checkSuffix(fileChooser.getSelectedFile(), this.suffix));
        }
    }

    public static interface ExpressionToFileExporterFactory {
        public ExpressionToFileExporter create();
    }
}

