/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.testing;

import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.shapes.ShapeFactory;
import de.neemann.digital.gui.Main;
import de.neemann.digital.gui.components.testing.ValueTableDialog;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.FolderTestRunner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class TestAllDialog
extends JDialog {
    private final FolderTestRunner folderTestRunner;

    public TestAllDialog(final Frame frame, File folder, ShapeFactory shapeFactory, final ElementLibrary library) {
        super(frame, Lang.get("msg_testResult", new Object[0]), false);
        this.folderTestRunner = new FolderTestRunner(folder);
        FileModel tableModel = new FileModel(this.folderTestRunner.getFiles());
        final JTable table = new JTable(tableModel);
        table.setRowSelectionAllowed(true);
        TableRowSorter<FileModel> sorter = new TableRowSorter<FileModel>(tableModel);
        sorter.setComparator(1, (f1, f2) -> -Integer.compare(f1.getStatus().ordinal(), f2.getStatus().ordinal()));
        table.setRowSorter(sorter);
        table.getColumnModel().getColumn(1).setCellRenderer(new StateRenderer());
        this.getContentPane().add(new JScrollPane(table));
        this.pack();
        this.setLocationRelativeTo(frame);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TestAllDialog.this.openCircuit(table, frame, library);
                }
            }
        });
        table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == ' ') {
                    TestAllDialog.this.openCircuit(table, frame, library);
                }
            }
        });
        this.folderTestRunner.startTests((f, row) -> SwingUtilities.invokeLater(() -> tableModel.messageChanged(row)), shapeFactory, library);
    }

    private void openCircuit(JTable table, Frame frame, ElementLibrary library) {
        int row = table.getSelectedRow();
        if (row >= 0) {
            File f = this.folderTestRunner.getFiles().get(row).getFile();
            new Main.MainBuilder().setParent(frame).setFileToOpen(f).setLibrary(library).keepPrefMainFile().openLater();
        }
    }

    public FolderTestRunner getFolderTestRunner() {
        return this.folderTestRunner;
    }

    private static final class FileModel
    implements TableModel {
        private final ArrayList<FolderTestRunner.FileToTest> files;
        private ArrayList<TableModelListener> listener;

        private FileModel(ArrayList<FolderTestRunner.FileToTest> files) {
            this.files = files;
            this.listener = new ArrayList();
        }

        @Override
        public int getRowCount() {
            return this.files.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int i) {
            switch (i) {
                case 0: {
                    return Lang.get("msg_testFile", new Object[0]);
                }
            }
            return Lang.get("msg_testResult", new Object[0]);
        }

        @Override
        public Class<?> getColumnClass(int i) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int i, int i1) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int col) {
            FolderTestRunner.FileToTest file = this.files.get(row);
            switch (col) {
                case 0: {
                    return file.getName();
                }
            }
            return file;
        }

        @Override
        public void setValueAt(Object o, int i, int i1) {
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
            this.listener.add(tableModelListener);
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
            this.listener.remove(tableModelListener);
        }

        private void messageChanged(int row) {
            TableModelEvent te = new TableModelEvent(this, row, row, 1);
            for (TableModelListener l : this.listener) {
                l.tableChanged(te);
            }
        }
    }

    private static final class StateRenderer
    extends DefaultTableCellRenderer {
        private StateRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object o, boolean sel, boolean b1, int row, int i1) {
            JLabel tc = (JLabel)super.getTableCellRendererComponent(jTable, o, sel, b1, row, i1);
            FolderTestRunner.FileToTest f = (FolderTestRunner.FileToTest)o;
            if (f != null) {
                Color color;
                switch (f.getStatus()) {
                    case error: {
                        color = Color.LIGHT_GRAY;
                        break;
                    }
                    case passed: {
                        color = ValueTableDialog.PASSED_COLOR;
                        break;
                    }
                    case failed: {
                        color = ValueTableDialog.FAILED_COLOR;
                        break;
                    }
                    default: {
                        color = Color.WHITE;
                    }
                }
                if (sel) {
                    color = color.darker();
                }
                tc.setBackground(color);
                tc.setText(f.getMessage());
            }
            return tc;
        }
    }
}

