/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.testing;

import de.neemann.digital.core.ErrorDetector;
import de.neemann.digital.data.Value;
import de.neemann.digital.data.ValueTable;
import de.neemann.digital.data.ValueTableModel;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.gui.Main;
import de.neemann.digital.gui.SaveAsHelper;
import de.neemann.digital.gui.components.data.GraphDialog;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.TestCaseDescription;
import de.neemann.digital.testing.TestExecutor;
import de.neemann.digital.testing.TestResult;
import de.neemann.digital.testing.TestingDataException;
import de.neemann.digital.testing.parser.TestRow;
import de.neemann.gui.IconCreator;
import de.neemann.gui.LineBreaker;
import de.neemann.gui.MyFileChooser;
import de.neemann.gui.ToolTipAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;

public class ValueTableDialog
extends JDialog {
    static final Color FAILED_COLOR = new Color(255, 200, 200);
    static final Color PASSED_COLOR = new Color(200, 255, 200);
    private static final Icon ICON_FAILED = IconCreator.create("testFailed.png");
    private static final Icon ICON_PASSED = IconCreator.create("testPassed.png");
    private static final Icon ICON_GRAPH = IconCreator.create("measurement-graph.png");
    private final ArrayList<ValueTableHolder> resultTableData;
    private final JTabbedPane tp;
    private final Window owner;
    private final ToolTipAction asGraph;

    public ValueTableDialog(Window owner, String title) {
        super(owner, title, Dialog.ModalityType.MODELESS);
        this.owner = owner;
        this.setDefaultCloseOperation(2);
        this.resultTableData = new ArrayList();
        this.tp = new JTabbedPane();
        JMenuBar bar = new JMenuBar();
        JMenu file = new JMenu(Lang.get("menu_file", new Object[0]));
        bar.add(file);
        file.add(new ToolTipAction(Lang.get("menu_saveData", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                int tab = ValueTableDialog.this.tp.getSelectedIndex();
                if (tab < 0) {
                    tab = 0;
                }
                MyFileChooser fileChooser = new MyFileChooser();
                fileChooser.setFileFilter(new FileNameExtensionFilter("Comma Separated Values", "csv"));
                new SaveAsHelper(ValueTableDialog.this, fileChooser, "csv").checkOverwrite(((ValueTableHolder)ValueTableDialog.this.resultTableData.get(tab)).valueTable::saveCSV);
            }
        }.setToolTip(Lang.get("menu_saveData_tt", new Object[0])).createJMenuItem());
        JMenu view = new JMenu(Lang.get("menu_view", new Object[0]));
        this.asGraph = new ToolTipAction(Lang.get("menu_showDataAsGraph", new Object[0]), ICON_GRAPH){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int tab = ValueTableDialog.this.tp.getSelectedIndex();
                if (tab < 0) {
                    tab = 0;
                }
                new GraphDialog((Window)ValueTableDialog.this, Lang.get("win_testdata_N", ValueTableDialog.this.tp.getTitleAt(tab)), ((ValueTableHolder)ValueTableDialog.this.resultTableData.get(tab)).valueTable).disableTable().setVisible(true);
            }
        }.setToolTip(Lang.get("menu_showDataAsGraph_tt", new Object[0]));
        view.add(this.asGraph.createJMenuItem());
        bar.add(view);
        this.setJMenuBar(bar);
        JToolBar toolBar = new JToolBar();
        toolBar.add(this.asGraph.createJButtonNoText());
        this.getContentPane().add((Component)toolBar, "North");
        this.getContentPane().add(this.tp);
    }

    public ValueTableDialog addTestResult(List<Circuit.TestCase> tsl, Circuit circuit, ElementLibrary library) throws TestingDataException {
        Collections.sort(tsl);
        int i = 0;
        int errorTabIndex = -1;
        for (Circuit.TestCase ts : tsl) {
            ErrorDetector errorDetector = new ErrorDetector();
            try {
                Icon tabIcon;
                String tabName;
                TestResult testResult = new TestExecutor(ts, circuit, library).addObserver(errorDetector).execute();
                if (testResult.allPassed()) {
                    tabName = Lang.get("msg_test_N_Passed", ts.getLabel());
                    tabIcon = ICON_PASSED;
                } else {
                    tabName = Lang.get("msg_test_N_Failed", ts.getLabel());
                    tabIcon = ICON_FAILED;
                    errorTabIndex = i;
                }
                if (testResult.toManyResults()) {
                    tabName = String.valueOf(tabName) + " " + Lang.get("msg_test_missingLines", new Object[0]);
                }
                ValueTableHolder vth = new ValueTableHolder(testResult.getValueTable(), ts.getTestCaseDescription());
                this.tp.addTab(tabName, tabIcon, new JScrollPane(this.createTable(vth)));
                if (testResult.toManyResults()) {
                    this.tp.setToolTipTextAt(i, new LineBreaker().toHTML().breakLines(Lang.get("msg_test_missingLines_tt", new Object[0])));
                }
                this.resultTableData.add(vth);
                ++i;
                errorDetector.check();
            }
            catch (Exception e) {
                throw new TestingDataException(Lang.get("err_whileExecutingTests_N0", ts.getLabel()), e);
            }
        }
        if (errorTabIndex >= 0) {
            this.tp.setSelectedIndex(errorTabIndex);
        }
        this.pack();
        this.setLocationRelativeTo(this.owner);
        return this;
    }

    public ValueTableDialog addValueTable(String name, ValueTable valueTable) {
        this.tp.addTab(name, new JScrollPane(this.createTable(new ValueTableHolder(valueTable))));
        this.resultTableData.add(new ValueTableHolder(valueTable));
        this.pack();
        this.setLocationRelativeTo(this.owner);
        return this;
    }

    private JTable createTable(final ValueTableHolder valueTableHolder) {
        final ValueTableModel vtm = new ValueTableModel(valueTableHolder.valueTable);
        final JTable table = new JTable(vtm);
        table.setDefaultRenderer(Value.class, new ValueRenderer());
        table.setDefaultRenderer(Integer.class, new NumberRenderer());
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int r = table.getSelectedRow();
                if (r >= 0 && r < vtm.getRowCount() && valueTableHolder.testCaseDescription != null) {
                    TestRow row = vtm.getRow(r);
                    int testRow = row.getRow();
                    if (ValueTableDialog.this.owner instanceof Main && testRow >= 0) {
                        Main main = (Main)ValueTableDialog.this.owner;
                        main.startSimulation(m -> new TestExecutor("", valueTableHolder.testCaseDescription, m).executeTo(testRow));
                    }
                }
            }
        });
        Font font = table.getFont();
        table.setRowHeight(font.getSize() * 6 / 5);
        return table;
    }

    public ValueTableDialog disableGraph() {
        this.asGraph.setEnabled(false);
        return this;
    }

    private static class NumberRenderer
    extends DefaultTableCellRenderer {
        private static final Color NUM_BACKGROUND_COLOR = new Color(238, 238, 238);

        private NumberRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel comp = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            comp.setBackground(NUM_BACKGROUND_COLOR);
            comp.setHorizontalAlignment(4);
            return comp;
        }
    }

    private static class ValueRenderer
    extends DefaultTableCellRenderer {
        private ValueRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel comp = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Value v = (Value)value;
            if (v != null) {
                comp.setText(v.toString());
                comp.setHorizontalAlignment(0);
                switch (((Value)value).getState()) {
                    case NORMAL: {
                        comp.setBackground(Color.WHITE);
                        break;
                    }
                    case FAIL: {
                        comp.setBackground(FAILED_COLOR);
                        break;
                    }
                    case PASS: {
                        comp.setBackground(PASSED_COLOR);
                    }
                }
            }
            return comp;
        }
    }

    private static final class ValueTableHolder {
        private final ValueTable valueTable;
        private final TestCaseDescription testCaseDescription;

        private ValueTableHolder(ValueTable valueTable) {
            this.valueTable = valueTable;
            this.testCaseDescription = null;
        }

        private ValueTableHolder(ValueTable valueTable, TestCaseDescription testCaseDescription) {
            this.valueTable = valueTable;
            this.testCaseDescription = testCaseDescription;
        }
    }
}

