/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.tree;

import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.library.LibraryListener;
import de.neemann.digital.draw.library.LibraryNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class LibraryTreeModel
implements TreeModel,
LibraryListener {
    private final LibraryNode root;
    private final ElementLibrary library;
    private final Filter filter;
    private final ArrayList<TreeModelListener> listeners = new ArrayList();
    private final HashMap<LibraryNode, Container> map;

    public LibraryTreeModel(ElementLibrary library) {
        this(library, null);
    }

    public LibraryTreeModel(ElementLibrary library, Filter filter) {
        this.root = library.getRoot();
        this.library = library;
        this.filter = filter;
        this.map = new HashMap();
        library.addListener(this);
    }

    public void close() {
        this.library.removeListener(this);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object o, int i) {
        return this.getContainer((LibraryNode)o).getChild(i);
    }

    @Override
    public int getChildCount(Object o) {
        return this.getContainer((LibraryNode)o).size();
    }

    @Override
    public boolean isLeaf(Object o) {
        return ((LibraryNode)o).isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object o) {
    }

    @Override
    public int getIndexOfChild(Object o, Object o1) {
        return this.getContainer((LibraryNode)o).indexOf((LibraryNode)o1);
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(treeModelListener);
    }

    @Override
    public void libraryChanged(LibraryNode node) {
        if (node.isLeaf()) {
            this.map.remove(node);
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new TreePath(node.getPath()));
            for (TreeModelListener l : this.listeners) {
                l.treeNodesChanged(treeModelEvent);
            }
        } else {
            this.map.clear();
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new TreePath(this.root.getPath()));
            for (TreeModelListener l : this.listeners) {
                l.treeStructureChanged(treeModelEvent);
            }
        }
    }

    public LibraryNode getFirstLeafParent() {
        Container c = this.getContainer(this.root);
        if (c.size() == 0) {
            return this.root;
        }
        while (true) {
            for (LibraryNode n : c) {
                if (!n.isLeaf()) continue;
                return c.node;
            }
            c = this.getContainer(c.getChild(0));
        }
    }

    public boolean isFiltered() {
        return this.filter != null;
    }

    private Container getContainer(LibraryNode libraryNode) {
        Container c = this.map.get(libraryNode);
        if (c == null) {
            c = new Container(libraryNode, this.filter);
            this.map.put(libraryNode, c);
        }
        return c;
    }

    private final class Container
    implements Iterable<LibraryNode> {
        private final ArrayList<LibraryNode> list;
        private final LibraryNode node;

        private Container(LibraryNode libraryNode, Filter filter) {
            this.list = new ArrayList(libraryNode.size());
            this.node = libraryNode;
            for (LibraryNode ln : libraryNode) {
                if (ln.isHidden()) continue;
                if (filter == null) {
                    this.list.add(ln);
                    continue;
                }
                if (ln.isLeaf()) {
                    if (!filter.accept(ln)) continue;
                    this.list.add(ln);
                    continue;
                }
                Container c = new Container(ln, filter);
                if (c.size() <= 0) continue;
                this.list.add(ln);
                LibraryTreeModel.this.map.put(ln, c);
            }
        }

        private LibraryNode getChild(int i) {
            return this.list.get(i);
        }

        private int size() {
            return this.list.size();
        }

        private int indexOf(LibraryNode o1) {
            return this.list.indexOf(o1);
        }

        @Override
        public Iterator<LibraryNode> iterator() {
            return this.list.iterator();
        }
    }

    public static interface Filter {
        public boolean accept(LibraryNode var1);
    }
}

