/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.release;

import de.neemann.digital.gui.release.ReleaseInfo;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.InfoDialog;
import java.awt.Window;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;

public final class CheckForNewRelease {
    private static final long ADAY = 86400000L;
    private static final String PREF_LAST = "last";
    private static final String PREF_ASKED = "asked";
    private static final Preferences PREFS = Preferences.userRoot().node("dig").node("rev");

    private CheckForNewRelease() {
    }

    private static void startIfNewRelease(Interface anInterface) {
        long lastAsked = PREFS.getLong(PREF_LAST, -1L);
        long time = System.currentTimeMillis();
        if (time - lastAsked < 86400000L) {
            return;
        }
        PREFS.putLong(PREF_LAST, time);
        Thread thread = new Thread(() -> {
            String runningRev = InfoDialog.getInstance().getRevision();
            if (runningRev.equals("unknown") || runningRev.length() > 7) {
                return;
            }
            try {
                ReleaseInfo info = new ReleaseInfo();
                String latestRev = info.getVersion();
                if (latestRev != null) {
                    String asked = PREFS.get(PREF_ASKED, "none");
                    if (asked.equals(latestRev)) {
                        return;
                    }
                    PREFS.put(PREF_ASKED, latestRev);
                    if (runningRev.equals(latestRev)) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> anInterface.showMessage(latestRev));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public static void showReleaseDialog(Window parent) {
        CheckForNewRelease.startIfNewRelease(latestRev -> {
            String msg = Lang.get("msg_newRelease_N", latestRev);
            InfoDialog.showInfo(parent, msg, "");
        });
    }

    private static interface Interface {
        public void showMessage(String var1);
    }
}

