/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.hgs.function;

import de.neemann.digital.hdl.hgs.Context;
import de.neemann.digital.hdl.hgs.Expression;
import de.neemann.digital.hdl.hgs.HGSEvalException;
import de.neemann.digital.hdl.hgs.HGSMap;
import de.neemann.digital.hdl.hgs.function.InnerFunction;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;

public final class JavaClass<T> {
    private final HashMap<String, MyMethod<T>> methods = new HashMap();

    public JavaClass(Class<T> clazz) {
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            int mod = m.getModifiers();
            if (Modifier.isPublic(mod)) {
                String name = m.getName();
                if (this.methods.containsKey(name)) {
                    throw new RuntimeException("Method overloading (" + name + ") is not supported! Try to use the ellipsis (...) instead.");
                }
                this.methods.put(name, new MyMethod(m));
            }
            ++n2;
        }
    }

    public HGSMap createMap(T instance) {
        return new MethodMap(this, instance);
    }

    private static final class MethodCall<T>
    extends InnerFunction {
        private final MyMethod<T> m;
        private final T instance;

        private MethodCall(MyMethod<T> m, T instance) {
            super(((MyMethod)m).argCount);
            this.m = m;
            this.instance = instance;
        }

        @Override
        public Object call(Context c, ArrayList<Expression> args) throws HGSEvalException {
            return ((MyMethod)this.m).call(this.instance, c, args);
        }
    }

    private static final class MethodMap<T>
    implements HGSMap {
        private final JavaClass<T> javaClass;
        private final T instance;

        private MethodMap(JavaClass<T> javaClass, T instance) {
            this.javaClass = javaClass;
            this.instance = instance;
        }

        @Override
        public Object hgsMapGet(String key) {
            MyMethod m = (MyMethod)((JavaClass)this.javaClass).methods.get(key);
            if (m == null) {
                return null;
            }
            return new MethodCall(m, this.instance);
        }
    }

    private static final class MyMethod<T> {
        private final Method method;
        private final boolean isStatic;
        private final boolean addContext;
        private final int argCount;
        private final int javaArgCount;
        private final boolean isVarArgs;
        private final Class<?> compType;

        private MyMethod(Method method) {
            this.method = method;
            this.isStatic = Modifier.isStatic(method.getModifiers());
            Class<?>[] argTypes = method.getParameterTypes();
            this.javaArgCount = argTypes.length;
            this.addContext = argTypes.length > 0 && argTypes[0].isAssignableFrom(Context.class);
            this.isVarArgs = method.isVarArgs();
            if (this.isVarArgs) {
                this.argCount = -1;
                this.compType = argTypes[argTypes.length - 1].getComponentType();
            } else {
                this.argCount = this.addContext ? argTypes.length - 1 : argTypes.length;
                this.compType = null;
            }
        }

        private Object call(T instance, Context c, ArrayList<Expression> args) throws HGSEvalException {
            if (instance == null && !this.isStatic) {
                throw new HGSEvalException("Function " + this.method.getName() + " is not static!");
            }
            if (this.argCount >= 0 && this.argCount != args.size()) {
                throw new HGSEvalException("Wrong number of arguments! expected: " + this.argCount + ", but found:" + args.size());
            }
            Object[] a = new Object[this.javaArgCount];
            int i = 0;
            if (this.addContext) {
                a[0] = c;
                ++i;
            }
            if (!this.isVarArgs) {
                for (Expression exp : args) {
                    a[i] = exp.value(c);
                    ++i;
                }
            } else {
                try {
                    int fixed = this.javaArgCount - i - 1;
                    int n = 0;
                    while (n < fixed) {
                        a[i] = args.get(n).value(c);
                        ++i;
                        ++n;
                    }
                    int numVarArgs = args.size() - fixed;
                    Object varArgs = Array.newInstance(this.compType, numVarArgs);
                    int n2 = fixed;
                    while (n2 < args.size()) {
                        Array.set(varArgs, n2 - fixed, args.get(n2).value(c));
                        ++n2;
                    }
                    a[i] = varArgs;
                }
                catch (RuntimeException e) {
                    throw new HGSEvalException("type error assigning value to var array in " + this.method.getName() + ". Type " + this.compType.getSimpleName() + " is required.");
                }
            }
            try {
                return this.method.invoke(instance, a);
            }
            catch (IllegalAccessException | RuntimeException | InvocationTargetException e) {
                throw new HGSEvalException("Error invoking the java method " + this.method.getName() + "!", e);
            }
        }
    }
}

