/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.hgs.refs;

import de.neemann.digital.hdl.hgs.Context;
import de.neemann.digital.hdl.hgs.Expression;
import de.neemann.digital.hdl.hgs.HGSArray;
import de.neemann.digital.hdl.hgs.HGSEvalException;
import de.neemann.digital.hdl.hgs.Value;
import de.neemann.digital.hdl.hgs.refs.Reference;

public class ReferenceToArray
implements Reference {
    private final Reference parent;
    private final Expression index;

    public ReferenceToArray(Reference parent, Expression index) {
        this.parent = parent;
        this.index = index;
    }

    @Override
    public void declareVar(Context context, Object initial) throws HGSEvalException {
        int i = Value.toInt(this.index.value(context));
        HGSArray array = Value.toArray(this.parent.get(context));
        if (i < 0 || i > array.hgsArraySize()) {
            throw new HGSEvalException("Index out of bounds: " + i);
        }
        array.hgsArrayAdd(initial);
    }

    @Override
    public void set(Context context, Object value) throws HGSEvalException {
        int i = Value.toInt(this.index.value(context));
        HGSArray array = Value.toArray(this.parent.get(context));
        if (i < 0 || i >= array.hgsArraySize()) {
            throw new HGSEvalException("Index out of bounds: " + i);
        }
        array.hgsArraySet(i, value);
    }

    @Override
    public Object get(Context context) throws HGSEvalException {
        int i = Value.toInt(this.index.value(context));
        HGSArray array = Value.toArray(this.parent.get(context));
        if (i < 0 || i >= array.hgsArraySize()) {
            throw new HGSEvalException("Index out of bounds: " + i);
        }
        return array.hgsArrayGet(i);
    }
}

