/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.model2;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.hdl.model2.HDLModel;
import de.neemann.digital.hdl.model2.HDLNet;
import de.neemann.digital.hdl.model2.HDLPort;
import de.neemann.digital.hdl.model2.expression.Expression;
import de.neemann.digital.hdl.model2.expression.Visitor;
import de.neemann.digital.hdl.printer.CodePrinter;
import java.io.IOException;
import java.util.ArrayList;

public abstract class HDLNode {
    private final String elementName;
    private final ElementAttributes elementAttributes;
    private final HDLModel.BitProvider bitProvider;
    private final ArrayList<HDLPort> inputs;
    private final ArrayList<HDLPort> outputs;
    private final ArrayList<HDLPort> inOutputs;
    private String hdlEntityName;

    public HDLNode(String elementName, ElementAttributes elementAttributes, HDLModel.BitProvider bitProvider) {
        this.elementName = elementName;
        this.elementAttributes = elementAttributes;
        this.bitProvider = bitProvider;
        this.inputs = new ArrayList();
        this.outputs = new ArrayList();
        this.inOutputs = new ArrayList();
    }

    public HDLNode addPort(HDLPort port) {
        switch (port.getDirection()) {
            case IN: {
                this.inputs.add(port);
                break;
            }
            case OUT: {
                this.outputs.add(port);
                break;
            }
            case INOUT: {
                this.inOutputs.add(port);
            }
        }
        port.setParent(this);
        return this;
    }

    public String toString() {
        return String.valueOf(this.elementName) + " " + this.inputs + " " + this.outputs;
    }

    public String getElementName() {
        return this.elementName;
    }

    public ElementAttributes getElementAttributes() {
        return this.elementAttributes;
    }

    public ArrayList<HDLPort> getInputs() {
        return this.inputs;
    }

    public HDLPort getOutput() {
        return this.outputs.get(0);
    }

    public ArrayList<HDLPort> getOutputs() {
        return this.outputs;
    }

    public ArrayList<HDLPort> getInOutputs() {
        return this.inOutputs;
    }

    int getBits(String name) {
        return this.bitProvider.getBits(name);
    }

    public void print(CodePrinter out) throws IOException {
        out.print("in");
        this.printWithLocal(out, this.inputs);
        out.print("out");
        this.printWithLocal(out, this.outputs);
        if (!this.inOutputs.isEmpty()) {
            out.print("inOut");
            this.printWithLocal(out, this.inOutputs);
        }
    }

    private void printWithLocal(CodePrinter out, ArrayList<HDLPort> ports) throws IOException {
        boolean first = true;
        for (HDLPort p : ports) {
            if (first) {
                first = false;
                out.print("(");
            } else {
                out.print(", ");
            }
            p.print(out);
        }
        if (first) {
            out.print("(");
        }
        out.println(")");
    }

    public boolean hasInput(HDLPort i) {
        for (HDLPort p : this.inputs) {
            if (p.getNet() != i.getNet()) continue;
            return true;
        }
        return false;
    }

    public void replaceNet(HDLNet oldNet, HDLNet newNet) {
    }

    public void setHdlEntityName(String hdlEntityName) {
        this.hdlEntityName = hdlEntityName;
    }

    public String getHdlEntityName() {
        return this.hdlEntityName;
    }

    public void rename(HDLModel.Renaming renaming) {
        for (HDLPort p : this.outputs) {
            p.rename(renaming);
        }
        for (HDLPort p : this.inputs) {
            p.rename(renaming);
        }
        for (HDLPort p : this.inOutputs) {
            p.rename(renaming);
        }
    }

    public abstract void replaceNetByExpression(HDLNet var1, Expression var2);

    public abstract <V extends Visitor> V traverseExpressions(V var1);
}

