/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.model2;

import de.neemann.digital.core.wiring.Splitter;
import de.neemann.digital.hdl.model2.HDLNet;
import de.neemann.digital.hdl.model2.HDLNode;
import de.neemann.digital.hdl.model2.HDLPort;
import de.neemann.digital.hdl.model2.expression.Expression;
import de.neemann.digital.hdl.model2.expression.Visitor;
import de.neemann.digital.hdl.printer.CodePrinter;
import java.io.IOException;

public class HDLNodeSplitterOneToMany
extends HDLNode {
    private final Splitter.Ports outputSplit;

    HDLNodeSplitterOneToMany(HDLNode node, Splitter.Ports outputSplit) {
        super(node.getElementName(), node.getElementAttributes(), null);
        this.outputSplit = outputSplit;
        for (HDLPort p : node.getInputs()) {
            this.addPort(p);
        }
        for (HDLPort p : node.getOutputs()) {
            this.addPort(p);
        }
    }

    public Splitter.Ports getOutputSplit() {
        return this.outputSplit;
    }

    @Override
    public void print(CodePrinter out) throws IOException {
        super.print(out);
        int i = 0;
        HDLPort in = this.getInputs().get(0);
        for (Splitter.Port sp : this.outputSplit) {
            HDLPort p = this.getOutputs().get(i++);
            out.print(p.getNet().getName()).print(" := ").print(in.getNet().getName()).print("(").print(sp.getPos()).print("-").print(sp.getPos() + sp.getBits() - 1).println(")");
        }
    }

    @Override
    public void replaceNetByExpression(HDLNet net, Expression expression) {
    }

    @Override
    public <V extends Visitor> V traverseExpressions(V visitor) {
        throw new RuntimeException("HDLNodeSplitterOneToMany is not expression based!");
    }

    public String getSourceSignal() {
        return this.getInputs().get(0).getNet().getName();
    }
}

