/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.model2.expression;

import de.neemann.digital.core.Bits;
import de.neemann.digital.hdl.model2.HDLNet;
import de.neemann.digital.hdl.model2.HDLNode;
import de.neemann.digital.hdl.model2.HDLNodeAssignment;
import de.neemann.digital.hdl.model2.expression.Expression;
import de.neemann.digital.hdl.printer.CodePrinter;
import java.io.IOException;

public class ExprConstant
implements Expression {
    private long value;
    private int bits;

    public ExprConstant(ExprConstant constant) {
        this(constant.getValue(), constant.getBits());
    }

    public ExprConstant(long value, int bits) {
        this.bits = bits;
        this.value = value & Bits.mask(bits);
    }

    public long getValue() {
        return this.value;
    }

    public int getBits() {
        return this.bits;
    }

    @Override
    public void print(CodePrinter out) throws IOException {
        out.print(this.value).print(":").print(this.bits);
    }

    @Override
    public void replace(HDLNet net, Expression expression) {
    }

    public boolean isEqualTo(ExprConstant other) {
        return this.bits == other.bits && this.value == other.value;
    }

    public static ExprConstant isConstant(HDLNode node) {
        HDLNodeAssignment expr;
        if (node instanceof HDLNodeAssignment && (expr = (HDLNodeAssignment)node).getExpression() instanceof ExprConstant) {
            return (ExprConstant)expr.getExpression();
        }
        return null;
    }
}

