/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.verilog2;

import de.neemann.digital.hdl.model2.HDLModel;
import java.util.Arrays;
import java.util.HashSet;

public class VerilogRenaming
implements HDLModel.Renaming {
    private static final HashSet<String> KEYWORDS = new HashSet<String>(Arrays.asList("always", "always_comb", "always_ff", "always_latch", "and", "assign", "automatic", "begin", "buf", "bufif0", "bufif1", "case", "casex", "assert", "bins", "casez", "cell", "cmos", "config", "deassign", "default", "defparam", "design", "class", "constraint", "covergroup", "coverpoint", "cross", "disable", "edge", "else", "end", "endcase", "endconfig", "endfunction", "endgenerate", "endmodule", "endprimitive", "endspecify", "endtable", "endtask", "event", "for", "enum", "endclass", "endgroup", "endinterface", "endproperty", "endsequence", "force", "forever", "fork", "function", "generate", "genvar", "highz0", "highz1", "if", "ifnone", "incdir", "include", "initial", "inout", "input", "instance", "integer", "int", "interface", "join", "large", "liblist", "library", "localparam", "macromodule", "medium", "module", "logic", "nand", "negedge", "nmos", "nor", "noshowcancelledno", "not", "notif0", "notif1", "new", "or", "output", "parameter", "pmos", "posedge", "primitive", "pull0", "pull1", "packed", "pulldown", "pullup", "pulsestyle_oneventglitch", "pulsestyle_ondetectglitch", "property", "rand", "remos", "real", "realtime", "reg", "release", "repeat", "rnmos", "rpmos", "rtran", "rtranif0", "rtranif1", "scalared", "showcancelled", "signed", "small", "specify", "sequence", "specparam", "strong0", "strong1", "supply0", "supply1", "table", "task", "time", "string", "struct", "this", "typedef", "tran", "tranif0", "tranif1", "tri", "tri0", "tri1", "triand", "trior", "trireg", "unsigned", "use", "vectored", "wait", "wand", "weak0", "weak1", "while", "wire", "wor", "xnor", "xor"));

    @Override
    public String checkName(String name) {
        if (this.isKeyword(name) || !this.isFirstCharValid(name)) {
            return "\\" + this.replaceWhitespace(name) + " ";
        }
        return this.cleanName(name);
    }

    private String replaceWhitespace(String name) {
        return name.replace(' ', '_').replace('\t', '_');
    }

    private boolean isFirstCharValid(String name) {
        char c = name.charAt(0);
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    private boolean isKeyword(String str) {
        return KEYWORDS.contains(str.toLowerCase());
    }

    private String cleanName(String name) {
        StringBuilder sb = new StringBuilder();
        boolean needScaping = false;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '$') {
                sb.append(c);
            } else {
                switch (c) {
                    case '\\': {
                        break;
                    }
                    case '\t': 
                    case ' ': {
                        sb.append("_");
                        break;
                    }
                    case '!': 
                    case '/': 
                    case '~': 
                    case '\u00ac': {
                        sb.append("not");
                        break;
                    }
                    default: {
                        sb.append(c);
                        needScaping = true;
                    }
                }
            }
            ++i;
        }
        if (needScaping) {
            sb.insert(0, "\\");
            sb.append(" ");
        }
        return sb.toString();
    }
}

