/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.verilog2;

import de.neemann.digital.data.Value;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.hdl.model2.HDLCircuit;
import de.neemann.digital.hdl.model2.HDLException;
import de.neemann.digital.hdl.model2.HDLModel;
import de.neemann.digital.hdl.model2.HDLPort;
import de.neemann.digital.hdl.printer.CodePrinter;
import de.neemann.digital.hdl.printer.CodePrinterStr;
import de.neemann.digital.hdl.vhdl2.Separator;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.TestCaseDescription;
import de.neemann.digital.testing.TestingDataException;
import de.neemann.digital.testing.parser.Context;
import de.neemann.digital.testing.parser.LineListener;
import de.neemann.digital.testing.parser.ParserException;
import de.neemann.digital.testing.parser.TestRow;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VerilogTestBenchCreator {
    private final List<Circuit.TestCase> testCases;
    private final HDLCircuit main;
    private final String topModuleName;
    private final HDLModel.Renaming renaming;
    private final ArrayList<File> testFileWritten;

    public VerilogTestBenchCreator(Circuit circuit, HDLModel model, String topModuleName) {
        this.main = model.getMain();
        this.topModuleName = topModuleName;
        this.testCases = circuit.getTestCases();
        this.testFileWritten = new ArrayList();
        this.renaming = model.getRenaming();
    }

    public VerilogTestBenchCreator write(File file) throws IOException, HDLException {
        String filename = file.getName();
        int p = filename.indexOf(46);
        if (p > 0) {
            filename = filename.substring(0, p);
        }
        for (Circuit.TestCase tc : this.testCases) {
            if (tc.hasGenericCode()) {
                throw new HDLException(Lang.get("err_hdlTestCaseHasGenericCode", new Object[0]));
            }
            String testName = tc.getLabel();
            testName = testName.length() > 0 ? String.valueOf(filename) + "_" + testName + "_tb" : String.valueOf(filename) + "_tb";
            File f = new File(file.getParentFile(), String.valueOf(testName) + ".v");
            this.testFileWritten.add(f);
            Throwable throwable = null;
            Object var9_10 = null;
            try (CodePrinter out = new CodePrinter(f);){
                try {
                    this.writeTestBench(out, this.topModuleName, testName, tc);
                }
                catch (RuntimeException e) {
                    throw new HDLException(Lang.get("err_vhdlErrorWritingTestBench", new Object[0]), e);
                }
                catch (TestingDataException | ParserException ex) {
                    Logger.getLogger(VerilogTestBenchCreator.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return this;
    }

    public ArrayList<File> getTestFileWritten() {
        return this.testFileWritten;
    }

    private void writeTestBench(CodePrinter out, String moduleName, String testName, Circuit.TestCase tc) throws IOException, HDLException, TestingDataException, ParserException {
        out.print("//  A testbench for ").println(testName);
        out.println("`timescale 1us/1ns").println();
        out.print("module ").print(testName).println(";");
        out.inc();
        for (HDLPort p : this.main.getPorts()) {
            out.print("  ").print(this.getSignalDeclarationCode(p)).println(";");
        }
        out.println();
        out.print(moduleName).print(" ").print(moduleName).print("0 (").println();
        out.inc();
        Separator comma = new Separator(out, ",\n");
        for (HDLPort p : this.main.getPorts()) {
            comma.check();
            out.print(".").print(p.getName()).print("(").print(p.getName()).print(")");
        }
        out.dec().println().print(");").println().println();
        TestCaseDescription testdata = tc.getTestCaseDescription();
        ArrayList<HDLPort> dataOrder = new ArrayList<HDLPort>();
        ArrayList<HDLPort> inputsInOrder = new ArrayList<HDLPort>();
        ArrayList<HDLPort> outputsInOrder = new ArrayList<HDLPort>();
        for (String name : testdata.getNames()) {
            String saveName = this.renaming.checkName(name);
            boolean found = false;
            for (HDLPort p : this.main.getPorts()) {
                if (!p.getName().equals(saveName)) continue;
                dataOrder.add(p);
                if (p.getDirection() == HDLPort.Direction.OUT) {
                    inputsInOrder.add(p);
                } else {
                    outputsInOrder.add(p);
                }
                found = true;
                break;
            }
            if (found) continue;
            throw new TestingDataException(Lang.get("err_testSignal_N_notFound", name));
        }
        int rowBits = 0;
        for (HDLPort p : dataOrder) {
            rowBits += p.getBits();
        }
        CodePrinterStr outTmp = new CodePrinterStr();
        outTmp.inc();
        LineListenerVerilog parent = new LineListenerVerilog(outTmp, dataOrder, rowBits);
        testdata.getLines().emitLines(parent, new Context());
        int lineCount = parent.getLineCount();
        String patternRange1 = rowBits == 1 ? "" : String.format("[%d:0] ", rowBits - 1);
        String patternRange2 = lineCount == 1 ? "" : String.format("[0:%d]", lineCount - 1);
        out.inc();
        out.print("reg ").print(patternRange1).print("patterns").print(patternRange2).println(";");
        String loopVar = "i";
        int lv = 0;
        while (this.loopVarExists(loopVar, this.main.getPorts())) {
            loopVar = "i" + lv++;
        }
        out.print("integer ").print(loopVar).println(";");
        out.println().println("initial begin");
        out.println(outTmp.toString());
        out.inc();
        out.print(String.format("for (%1$s = 0; %1$s < %2$d; %1$s = %1$s + 1)\n", loopVar, lineCount));
        out.println("begin").inc();
        int rangeStart = rowBits - 1;
        for (HDLPort p : inputsInOrder) {
            int rangeEnd = rangeStart - p.getBits() + 1;
            String rangeStr = rangeStart != rangeEnd ? "[" + rangeStart + ":" + rangeEnd + "]" : "[" + rangeStart + "]";
            out.print(p.getName()).print(" = patterns[").print(loopVar).print("]").print(rangeStr).println(";");
            rangeStart -= p.getBits();
        }
        out.println("#10;");
        for (HDLPort p : outputsInOrder) {
            String dontCareValue = String.valueOf(p.getBits()) + "'hx";
            int rangeEnd = rangeStart - p.getBits() + 1;
            String rangeStr = rangeStart != rangeEnd ? "[" + rangeStart + ":" + rangeEnd + "]" : "[" + rangeStart + "]";
            out.print("if (patterns[").print(loopVar).print("]").print(rangeStr).print(" !== ").print(dontCareValue).println(")").println("begin");
            out.inc();
            out.print("if (").print(p.getName()).print(" !== patterns[").print(loopVar).print("]").print(rangeStr).println(")").println("begin");
            out.inc();
            out.print("$display(\"%d:").print(p.getName()).print(": (assertion error). Expected %h, found %h\", ").print(loopVar).print(", ").print("patterns[").print(loopVar).print("]").print(rangeStr).print(", ").print(p.getName()).print(");").println();
            out.println("$finish;");
            out.dec().println("end");
            out.dec().println("end");
            rangeStart -= p.getBits();
        }
        out.dec();
        out.println("end");
        out.println().println("$display(\"All tests passed.\");");
        out.dec().println("end");
        out.println("endmodule");
    }

    private boolean loopVarExists(String loopVar, ArrayList<HDLPort> ports) {
        for (HDLPort p : ports) {
            if (!p.getName().equals(loopVar)) continue;
            return true;
        }
        return false;
    }

    private String getSignalDeclarationCode(HDLPort p) throws HDLException {
        String declCode;
        switch (p.getDirection()) {
            case IN: {
                declCode = "wire ";
                break;
            }
            case OUT: {
                declCode = "reg ";
                break;
            }
            default: {
                declCode = "/* Invalid port */";
            }
        }
        if (p.getBits() > 1) {
            declCode = String.valueOf(declCode) + "[" + Integer.toString(p.getBits() - 1) + ":0] ";
        }
        declCode = String.valueOf(declCode) + p.getName();
        return declCode;
    }

    private static final class LineListenerVerilog
    implements LineListener {
        private final CodePrinter out;
        private final ArrayList<HDLPort> dataOrder;
        private final int rowBits;
        private int rowIndex;

        private LineListenerVerilog(CodePrinter out, ArrayList<HDLPort> dataOrder, int rowBits) {
            this.out = out;
            this.dataOrder = dataOrder;
            this.rowBits = rowBits;
            this.rowIndex = 0;
        }

        @Override
        public void add(TestRow row) {
            try {
                boolean containsClock = false;
                Value[] valueArray = row.getValues();
                int n = valueArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Value v = valueArray[n2];
                    if (v.getType() == Value.Type.CLOCK) {
                        containsClock = true;
                    }
                    ++n2;
                }
                if (containsClock) {
                    this.writeValues(row.getValues(), true, 0);
                    this.writeValues(row.getValues(), true, 1);
                }
                this.writeValues(row.getValues(), false, 0);
            }
            catch (HDLException | IOException e) {
                throw new RuntimeException(e);
            }
        }

        public int getLineCount() {
            return this.rowIndex;
        }

        private void writeValues(Value[] values, boolean isClock, int clock) throws IOException, HDLException {
            this.out.print("patterns[").print(this.rowIndex).print("] = ").print(this.rowBits).print("'b");
            int i = 0;
            while (i < values.length) {
                HDLPort p = this.dataOrder.get(i);
                if (p.getDirection() == HDLPort.Direction.OUT) {
                    if (values[i].getType() == Value.Type.CLOCK) {
                        this.out.print(clock);
                    } else {
                        this.out.print(this.toBinaryString(values[i], p.getBits()));
                    }
                    this.out.print("_");
                }
                ++i;
            }
            Separator sep = new Separator(this.out, "_");
            int i2 = 0;
            while (i2 < values.length) {
                HDLPort p = this.dataOrder.get(i2);
                if (p.getDirection() == HDLPort.Direction.IN) {
                    sep.check();
                    if (isClock) {
                        this.out.print(this.toBinaryString(0L, Value.Type.DONTCARE, p.getBits()));
                    } else {
                        this.out.print(this.toBinaryString(values[i2], p.getBits()));
                    }
                }
                ++i2;
            }
            this.out.println(";");
            ++this.rowIndex;
        }

        private String toBinaryString(Value v, int bits) {
            return this.toBinaryString(v.getValue(), v.getType(), bits);
        }

        private String toBinaryString(long val, Value.Type type, int bits) {
            String binStr = "";
            char fillCh = '0';
            switch (type) {
                case DONTCARE: {
                    fillCh = 'x';
                    break;
                }
                case HIGHZ: {
                    fillCh = 'z';
                    break;
                }
                default: {
                    long mask = bits < 64 ? (1L << bits) - 1L : -1L;
                    binStr = Long.toBinaryString(val & mask);
                }
            }
            StringBuilder sb = new StringBuilder();
            if (binStr.length() < bits) {
                int diff = bits - binStr.length();
                int i = 0;
                while (i < diff) {
                    sb.append(fillCh);
                    ++i;
                }
            }
            sb.append(binStr);
            return sb.toString();
        }
    }
}

