/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.verilog2.lib;

import de.neemann.digital.hdl.hgs.Context;
import de.neemann.digital.hdl.hgs.HGSEvalException;
import de.neemann.digital.hdl.hgs.Parser;
import de.neemann.digital.hdl.hgs.ParserException;
import de.neemann.digital.hdl.hgs.Statement;
import de.neemann.digital.hdl.hgs.Value;
import de.neemann.digital.hdl.model2.HDLException;
import de.neemann.digital.hdl.model2.HDLNode;
import de.neemann.digital.hdl.printer.CodePrinter;
import de.neemann.digital.hdl.verilog2.lib.VerilogElement;
import de.neemann.digital.hdl.vhdl2.Separator;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class VerilogTemplate
implements VerilogElement {
    private static final String MODULE_PREFIX = "DIG_";
    private final String moduleBaseName;
    private final Statement statements;
    private HashMap<String, Module> modules;

    public VerilogTemplate(String elementName, ClassLoader cl) throws IOException, HDLException {
        this.moduleBaseName = MODULE_PREFIX + elementName;
        this.modules = new HashMap();
        try {
            this.statements = Parser.createFromJar(VerilogTemplate.createFileName(this.moduleBaseName), cl);
        }
        catch (ParserException ex) {
            throw new HDLException(ex.getMessage());
        }
        if (this.statements == null) {
            throw new HDLException("Invalid verilog template file. Template is empty.");
        }
    }

    private static String createFileName(String name) {
        return "verilog/" + name + ".v";
    }

    public static String neededFileName(String elementName) {
        return VerilogTemplate.createFileName(MODULE_PREFIX + elementName);
    }

    @Override
    public String print(CodePrinter out, HDLNode node, File root) throws HGSEvalException, IOException {
        Module m = this.getModule(node, root);
        if (!m.isWritten) {
            out.println(m.code);
            m.setWritten();
        }
        return m.name;
    }

    @Override
    public void writeGenericMap(CodePrinter out, HDLNode node, File root) throws IOException {
        try {
            Module m = this.getModule(node, root);
            List generics = m.getGenerics();
            if (generics == null || generics.isEmpty()) {
                return;
            }
            out.println("#(");
            out.inc();
            Separator comma = new Separator(out, ",\n");
            for (Object objv : generics) {
                String keyName = Value.toString(objv);
                Object keyVal = node.getElementAttributes().hgsMapGet(keyName);
                String kvs = keyVal instanceof Boolean ? ((Boolean)keyVal != false ? "1" : "0") : keyVal.toString();
                comma.check();
                out.print(".").print(keyName).print("(").print(kvs).print(")");
            }
            out.dec();
            out.println().println(")");
        }
        catch (HGSEvalException ex) {
            throw new IOException("error evaluating the template " + VerilogTemplate.createFileName(this.moduleBaseName), ex);
        }
    }

    private Module getModule(HDLNode node, File root) throws HGSEvalException {
        Module genModule = new Module(node, this.moduleBaseName, root);
        Module e = this.modules.get(genModule.name);
        if (e == null) {
            this.modules.put(genModule.name, genModule);
            return genModule;
        }
        if (!genModule.code.equals(e.code)) {
            throw new HGSEvalException(Lang.get("err_ifExternalComponentIsUsedTwiceCodeMustBeIdentical_N", genModule.name));
        }
        return e;
    }

    private final class Module {
        private final String code;
        private String name;
        private final List generics;
        private boolean isWritten = false;

        private Module(HDLNode node, String name, File root) throws HGSEvalException {
            this.name = name;
            Context ctx = this.createRuntimeContext(node, root);
            try {
                VerilogTemplate.this.statements.execute(ctx);
            }
            catch (HGSEvalException e) {
                throw new HGSEvalException("error evaluating hgs code " + name, e);
            }
            this.code = ctx.toString();
            if (ctx.contains("moduleName")) {
                this.name = Value.toString(ctx.getVar("moduleName"));
            }
            this.generics = (List)ctx.getVar("generics");
        }

        private Context createRuntimeContext(HDLNode node, File root) throws HGSEvalException {
            Context ctx = new Context(root);
            ctx.declareVar("moduleName", this.name);
            ctx.declareVar("generics", new ArrayList());
            ctx.declareVar("elem", node.getElementAttributes());
            ctx.declareVar("inp", node.getInputs());
            ctx.declareVar("outp", node.getOutputs());
            return ctx;
        }

        private String getCode() {
            return this.code;
        }

        private boolean isWritten() {
            return this.isWritten;
        }

        private void setWritten() {
            this.isWritten = true;
        }

        private String getName() {
            return this.name;
        }

        private List getGenerics() {
            return this.generics;
        }
    }
}

