/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.vhdl2;

import de.neemann.digital.hdl.printer.CodePrinter;
import java.io.IOException;

public class Separator {
    private final String sep;
    private final CodePrinter out;
    private final String finalizerSeparator;
    private boolean first = true;
    private LineFinalizer lineFinalizer;

    public Separator(CodePrinter out, String sep) {
        this.sep = sep;
        this.out = out;
        this.finalizerSeparator = sep.length() > 0 && sep.charAt(sep.length() - 1) == '\n' ? sep.substring(0, sep.length() - 1) : sep;
    }

    public void check() throws IOException {
        if (this.first) {
            this.first = false;
        } else if (this.lineFinalizer == null) {
            this.printSeparator(this.out);
        } else {
            this.out.print(this.finalizerSeparator);
            this.lineFinalizer.finalizeLine(this.out);
            this.lineFinalizer = null;
        }
    }

    public void printSeparator(CodePrinter out) throws IOException {
        out.print(this.sep);
    }

    public void setLineFinalizer(LineFinalizer lineFinalizer) {
        this.lineFinalizer = lineFinalizer;
    }

    public void close() throws IOException {
        if (this.lineFinalizer != null) {
            this.lineFinalizer.finalizeLine(this.out);
        }
    }

    public static interface LineFinalizer {
        public void finalizeLine(CodePrinter var1) throws IOException;
    }
}

