/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.vhdl2.entities;

import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.hdl.hgs.Context;
import de.neemann.digital.hdl.hgs.HGSEvalException;
import de.neemann.digital.hdl.hgs.Parser;
import de.neemann.digital.hdl.hgs.ParserException;
import de.neemann.digital.hdl.hgs.Statement;
import de.neemann.digital.hdl.hgs.Value;
import de.neemann.digital.hdl.hgs.function.JavaClass;
import de.neemann.digital.hdl.model2.HDLNode;
import de.neemann.digital.hdl.printer.CodePrinter;
import de.neemann.digital.hdl.vhdl2.Separator;
import de.neemann.digital.hdl.vhdl2.entities.VHDLEntity;
import de.neemann.digital.hdl.vhdl2.entities.VHDLTemplateFunctions;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public class VHDLTemplate
implements VHDLEntity {
    private static final JavaClass<VHDLTemplateFunctions> TEMP_FUNCTIONS_CLASS = new JavaClass<VHDLTemplateFunctions>(VHDLTemplateFunctions.class);
    private static final String ENTITY_PREFIX = "DIG_";
    private final Statement statements;
    private final String entityName;
    private HashMap<String, Entity> entities;

    public VHDLTemplate(String name, ClassLoader cl) throws IOException {
        this.entityName = ENTITY_PREFIX + name;
        this.entities = new HashMap();
        try {
            this.statements = Parser.createFromJar(VHDLTemplate.createFileName(this.entityName), cl);
        }
        catch (ParserException e) {
            throw new IOException("error parsing template " + VHDLTemplate.createFileName(this.entityName), e);
        }
    }

    private static String createFileName(String name) {
        return "vhdl/" + name + ".tem";
    }

    public static boolean isTemplate(ElementTypeDescription etd) {
        URL url;
        ClassLoader cl = etd.getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return (url = cl.getResource(VHDLTemplate.createFileName(ENTITY_PREFIX + etd.getName()))) != null;
    }

    public static String neededFileName(String elementName) {
        return VHDLTemplate.createFileName(ENTITY_PREFIX + elementName);
    }

    @Override
    public String print(CodePrinter out, HDLNode node, File root) throws HGSEvalException, IOException {
        Entity e = this.getEntity(node, root);
        if (!e.isWritten()) {
            out.println().println(Value.trimRight(e.getCode())).println();
            e.setWritten();
        }
        return e.getName();
    }

    @Override
    public void writeGenericMap(CodePrinter out, HDLNode node, File root) throws IOException {
        try {
            Entity e = this.getEntity(node, root);
            if (!e.getGenerics().isEmpty()) {
                out.println("generic map (").inc();
                Separator semic = new Separator(out, ",\n");
                for (VHDLTemplateFunctions.Generic gen : e.getGenerics()) {
                    semic.check();
                    Object value = node.getElementAttributes().hgsMapGet(gen.getName());
                    out.print(gen.getName()).print(" => ").print(gen.format(value));
                }
                out.println(")").dec();
            }
        }
        catch (HGSEvalException e) {
            throw new IOException("error evaluating the template " + VHDLTemplate.createFileName(this.entityName), e);
        }
    }

    private Entity getEntity(HDLNode node, File root) throws HGSEvalException {
        Entity newGenerated = new Entity(node, this.entityName, root);
        Entity e = this.entities.get(newGenerated.name);
        if (e == null) {
            this.entities.put(newGenerated.name, newGenerated);
            return newGenerated;
        }
        if (!newGenerated.code.equals(e.code)) {
            throw new HGSEvalException(Lang.get("err_ifExternalComponentIsUsedTwiceCodeMustBeIdentical_N", newGenerated.name));
        }
        return e;
    }

    private final class Entity {
        private final String code;
        private final String name;
        private final VHDLTemplateFunctions helper = new VHDLTemplateFunctions();
        private boolean isWritten = false;

        private Entity(HDLNode node, String name, File root) throws HGSEvalException {
            Context c = new Context(root).declareVar("elem", node.getElementAttributes()).declareVar("vhdl", TEMP_FUNCTIONS_CLASS.createMap(this.helper));
            try {
                VHDLTemplate.this.statements.execute(c);
            }
            catch (HGSEvalException e) {
                throw new HGSEvalException("error evaluating hgs code " + name, e);
            }
            this.code = c.toString();
            this.name = c.contains("entityName") ? c.getVar("entityName").toString() : name;
        }

        private String getCode() {
            return this.code;
        }

        private boolean isWritten() {
            return this.isWritten;
        }

        private void setWritten() {
            this.isWritten = true;
        }

        private String getName() {
            return this.name;
        }

        private ArrayList<VHDLTemplateFunctions.Generic> getGenerics() {
            return this.helper.getGenerics();
        }
    }
}

