/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.testing;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.ModelEventType;
import de.neemann.digital.core.ModelStateObserverTyped;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.Signal;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.wiring.Clock;
import de.neemann.digital.data.Value;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.library.ElementNotFoundException;
import de.neemann.digital.draw.library.ResolveGenerics;
import de.neemann.digital.draw.model.ModelCreator;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.LineListenerResolveDontCare;
import de.neemann.digital.testing.TestCaseDescription;
import de.neemann.digital.testing.TestResult;
import de.neemann.digital.testing.TestResultListener;
import de.neemann.digital.testing.TestingDataException;
import de.neemann.digital.testing.parser.Context;
import de.neemann.digital.testing.parser.LineEmitter;
import de.neemann.digital.testing.parser.LineListener;
import de.neemann.digital.testing.parser.ParserException;
import de.neemann.digital.testing.parser.TestRow;
import de.neemann.digital.testing.parser.VirtualSignal;
import java.util.ArrayList;
import java.util.HashSet;

public class TestExecutor {
    private final String label;
    private final ArrayList<String> names;
    private final Model model;
    private final LineEmitter lines;
    private final Context context;
    private final ArrayList<TestSignal> inputs;
    private final ArrayList<TestSignal> outputs;
    private boolean allowMissingInputs;
    private boolean errorOccurred;

    public TestExecutor(Circuit.TestCase testCase, Circuit circuit, ElementLibrary library) throws TestingDataException, NodeException, ElementNotFoundException, PinException {
        this(testCase.getLabel(), testCase.getTestCaseDescription(), TestExecutor.createModel(testCase, circuit, library));
    }

    private static Model createModel(Circuit.TestCase testCase, Circuit circuit, ElementLibrary library) throws NodeException, ElementNotFoundException, PinException {
        Model model;
        if (circuit != null && circuit.getAttributes().get(Keys.IS_GENERIC).booleanValue() && testCase.hasGenericCode()) {
            Circuit c = new ResolveGenerics(circuit, library).resolveCircuit(testCase.getVisualElement().getElementAttributes()).getCircuit();
            model = new ModelCreator(c, library, false).createModel(false);
        } else {
            model = new ModelCreator(circuit, library).createModel(false);
        }
        return model;
    }

    public TestExecutor(TestCaseDescription testCase, Model model) throws TestingDataException {
        this("unknown", testCase, model);
    }

    public TestExecutor(String label, TestCaseDescription testCase, Model model) throws TestingDataException {
        int index;
        this.label = label;
        this.names = this.checkForPinNumbers(testCase.getNames(), model);
        this.model = model;
        this.lines = testCase.getLines();
        HashSet<String> usedSignals = new HashSet<String>();
        this.inputs = new ArrayList();
        this.outputs = new ArrayList();
        for (Signal s : model.getInputs()) {
            String outName;
            int inIndex;
            ObservableValue outValue;
            index = this.getIndexOf(s.getName());
            if (index >= 0) {
                this.inputs.add(new TestSignal(index, s.getValue()));
                this.addTo(usedSignals, s.getName());
            }
            if ((outValue = s.getBidirectionalReader()) == null || (inIndex = this.getIndexOf(outName = String.valueOf(s.getName()) + "_out")) < 0) continue;
            this.outputs.add(new TestSignal(inIndex, outValue));
            this.addTo(usedSignals, outName);
        }
        for (Clock c : model.getClocks()) {
            index = this.getIndexOf(c.getLabel());
            if (index < 0) continue;
            this.inputs.add(new TestSignal(index, c.getClockOutput()));
            this.addTo(usedSignals, c.getLabel());
        }
        for (Signal s : model.getTestOutputs()) {
            index = this.getIndexOf(s.getName());
            if (index < 0) continue;
            this.outputs.add(new TestSignal(index, s.getValue()));
            this.addTo(usedSignals, s.getName());
        }
        this.context = new Context().setModel(model).setSeedReset(testCase::resetSeed);
        for (VirtualSignal s : testCase.getVirtualSignals()) {
            int index2 = this.getIndexOf(s.getName());
            if (index2 < 0) continue;
            this.outputs.add(new TestSignal(index2, s.getValue(this.context)));
            this.addTo(usedSignals, s.getName());
        }
        for (String name : this.names) {
            if (usedSignals.contains(name)) continue;
            if (this.allowMissingInputs) {
                this.inputs.add(new TestSignal(this.getIndexOf(name), null));
                continue;
            }
            throw new TestingDataException(Lang.get("err_testSignal_N_notFound", name));
        }
        if (this.inputs.size() == 0) {
            throw new TestingDataException(Lang.get("err_noTestInputSignalsDefined", new Object[0]));
        }
        if (this.outputs.size() == 0) {
            throw new TestingDataException(Lang.get("err_noTestOutputSignalsDefined", new Object[0]));
        }
        testCase.getModelInitializer().init(model);
        model.init();
        model.addObserver(event -> {
            if (event.getType() == ModelEventType.ERROR_OCCURRED) {
                this.errorOccurred = true;
            }
        }, ModelEventType.ERROR_OCCURRED, new ModelEventType[0]);
    }

    private ArrayList<String> checkForPinNumbers(ArrayList<String> names, Model model) {
        ArrayList<String> returnNames = new ArrayList<String>();
        for (String n : names) {
            if (n.startsWith("/")) {
                String pin = n.substring(1).trim();
                String found = null;
                for (Signal signal : model.getSignals()) {
                    if (!pin.equals(signal.getPinNumber())) continue;
                    found = signal.getName();
                }
                if (found == null) {
                    for (Clock clock : model.getClocks()) {
                        if (!pin.equals(clock.getClockPin())) continue;
                        found = clock.getLabel();
                    }
                }
                if (found == null) {
                    returnNames.add(n);
                    continue;
                }
                returnNames.add(found);
                continue;
            }
            returnNames.add(n);
        }
        return returnNames;
    }

    public void executeTo(int row) throws ParserException, TestingDataException {
        this.execute(new TestResultListener(row){
            private int r;
            {
                this.r = n;
            }

            @Override
            public void add(TestRow testRow) {
                Value[] values = testRow.getValues();
                Value[] res = new Value[values.length];
                if (this.r >= 0) {
                    TestExecutor.this.advanceModel(testRow, values, res, this);
                    --this.r;
                }
            }

            @Override
            public void addClockRow(String description) {
            }
        }, false);
    }

    public TestResult execute() throws ParserException, TestingDataException {
        return this.execute(new TestResult(this), true);
    }

    private <LL extends LineListener> LL execute(LL lineListener, boolean closeModel) throws ParserException, TestingDataException {
        try {
            this.lines.emitLines(new LineListenerResolveDontCare(lineListener, this.inputs), this.context);
            LL LL = lineListener;
            return LL;
        }
        catch (RuntimeException re) {
            this.errorOccurred = true;
            throw new TestingDataException(Lang.get("err_whileExecutingTests_N0", this.label), re);
        }
        finally {
            if (closeModel) {
                this.model.close();
            }
        }
    }

    private void addTo(HashSet<String> signals, String name) throws TestingDataException {
        if (signals.contains(name)) {
            throw new TestingDataException(Lang.get("err_nameUsedTwice_N", name));
        }
        signals.add(name);
    }

    void advanceModel(TestRow testRow, Value[] values, Value[] res, TestResultListener trl) {
        boolean clockIsUsed = false;
        for (TestSignal in : this.inputs) {
            if (values[in.index].getType() != Value.Type.CLOCK) {
                if (in.value != null) {
                    values[in.index].copyTo(in.value);
                }
            } else {
                clockIsUsed = true;
            }
            res[((TestSignal)in).index] = values[in.index];
        }
        if (clockIsUsed) {
            this.model.doStep();
            trl.addClockRow(testRow.getDescription());
            for (TestSignal in : this.inputs) {
                if (values[in.index].getType() != Value.Type.CLOCK) continue;
                values[in.index].copyTo(in.value);
                res[((TestSignal)in).index] = values[in.index];
            }
            this.model.doStep();
            trl.addClockRow(testRow.getDescription());
            for (TestSignal in : this.inputs) {
                if (values[in.index].getType() != Value.Type.CLOCK) continue;
                in.value.setBool(!in.value.getBool());
                res[((TestSignal)in).index] = new Value(in.value);
            }
        }
        this.model.doStep();
    }

    private int getIndexOf(String name) {
        if (name == null || name.length() == 0) {
            return -1;
        }
        int i = 0;
        while (i < this.names.size()) {
            String n = this.names.get(i);
            if (n.equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public TestExecutor setAllowMissingInputs(boolean allowMissingInputs) {
        this.allowMissingInputs = allowMissingInputs;
        return this;
    }

    public TestExecutor addObserver(ModelStateObserverTyped observer) {
        this.model.addObserver(observer);
        return this;
    }

    public ArrayList<TestSignal> getOutputs() {
        return this.outputs;
    }

    public ArrayList<TestSignal> getInputs() {
        return this.inputs;
    }

    public boolean isErrorOccurred() {
        return this.errorOccurred;
    }

    public ArrayList<String> getNames() {
        return this.names;
    }

    public static final class TestSignal {
        private final int index;
        private final ObservableValue value;

        private TestSignal(int index, ObservableValue value) {
            this.index = index;
            this.value = value;
        }

        public int getIndex() {
            return this.index;
        }

        public ObservableValue getValue() {
            return this.value;
        }
    }
}

