/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.testing.parser;

import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.parser.Context;
import de.neemann.digital.testing.parser.LineEmitter;
import de.neemann.digital.testing.parser.LineListener;
import de.neemann.digital.testing.parser.ParserException;

public class LineEmitterRepeat
implements LineEmitter {
    private static final long MAX_LOOPS = 0x1000000L;
    private final String name;
    private final int size;
    private final LineEmitter inner;

    public LineEmitterRepeat(String name, long size, LineEmitter inner) throws ParserException {
        this.name = name;
        this.size = (int)size;
        this.inner = inner;
        if (size > 0x1000000L) {
            throw new ParserException(Lang.get("err_toManyIterations", new Object[0]));
        }
    }

    @Override
    public void emitLines(LineListener listener, Context context) throws ParserException {
        Context c = new Context(context);
        int i = 0;
        while (i < this.size) {
            c.setVar(this.name, i);
            this.inner.emitLines(listener, c);
            ++i;
        }
    }
}

