/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.testing.parser;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.Signal;
import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.core.memory.ProgramMemory;
import de.neemann.digital.core.memory.RAMInterface;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.TestingDataException;
import java.util.ArrayList;
import java.util.List;

public class ModelInitializer {
    private final ArrayList<ModelInit> inits = new ArrayList();

    ModelInitializer() {
    }

    void initSignal(String name, long value) {
        this.inits.add(new InitSignal(name, value));
    }

    void initProgramMemory(DataField memory) {
        this.inits.add(new InitProgramMemory(memory));
    }

    void initMemory(String ramName, int addr, long value) {
        this.inits.add(new InitMemory(ramName, addr, value));
    }

    public void init(Model model) throws TestingDataException {
        for (ModelInit mi : this.inits) {
            mi.init(model);
        }
    }

    private static final class InitMemory
    implements ModelInit {
        private final String memoryName;
        private final int addr;
        private final long value;

        private InitMemory(String memoryName, int addr, long value) {
            this.memoryName = memoryName;
            this.addr = addr;
            this.value = value;
        }

        @Override
        public void init(Model model) throws TestingDataException {
            List<Node> nodes = model.findNode(n -> n instanceof RAMInterface && ((RAMInterface)((Object)n)).getLabel().equals(this.memoryName));
            switch (nodes.size()) {
                case 0: {
                    throw new TestingDataException(Lang.get("err_noMemoryFound", this.memoryName));
                }
                case 1: {
                    ((RAMInterface)((Object)nodes.get(0))).getMemory().setData(this.addr, this.value);
                    break;
                }
                default: {
                    throw new TestingDataException(Lang.get("err_multipleMemoriesFound", this.memoryName));
                }
            }
        }
    }

    private static final class InitProgramMemory
    implements ModelInit {
        private final DataField dataField;

        private InitProgramMemory(DataField dataField) {
            this.dataField = dataField;
        }

        @Override
        public void init(Model model) throws TestingDataException {
            List<Node> nodes = model.findNode(n -> n instanceof ProgramMemory && ((ProgramMemory)((Object)n)).isProgramMemory());
            switch (nodes.size()) {
                case 0: {
                    throw new TestingDataException(Lang.get("err_noRomFound", new Object[0]));
                }
                case 1: {
                    ((ProgramMemory)((Object)nodes.get(0))).setProgramMemory(this.dataField);
                    break;
                }
                default: {
                    throw new TestingDataException(Lang.get("err_multipleRomsFound", new Object[0]));
                }
            }
        }
    }

    private static final class InitSignal
    implements ModelInit {
        private final String name;
        private final long value;

        private InitSignal(String name, long value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public void init(Model model) throws TestingDataException {
            Signal.Setter s = model.getSignalSetter(this.name);
            if (s == null) {
                throw new TestingDataException(Lang.get("err_testSignal_N_notFound", this.name));
            }
            s.set(this.value, 0L);
        }
    }

    private static interface ModelInit {
        public void init(Model var1) throws TestingDataException;
    }
}

