/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.gui;

import de.neemann.digital.lang.Lang;
import de.neemann.gui.ConfirmDialogBuilder;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class ClosingWindowListener
extends WindowAdapter {
    private static final String SAVE_CHANGES_MESSAGE = Lang.get("win_saveChanges", new Object[0]);
    private static final String CONFIRM_EXIT_MESSAGE = Lang.get("win_confirmExit", new Object[0]);
    private static final String STATE_CHANGED_MESSAGE = Lang.get("win_stateChanged", new Object[0]);
    private static final String NO_MESSAGE = Lang.get("btn_discard", new Object[0]);
    private static final String YES_MESSAGE = Lang.get("btn_save", new Object[0]);
    private static final String CANCEL_MESSAGE = Lang.get("btn_editFurther", new Object[0]);
    private final Component parent;
    private final GUICloser guiCloser;

    public ClosingWindowListener(JFrame parent, ConfirmSave confirmSave) {
        this(parent, confirmSave, true);
    }

    private ClosingWindowListener(final JFrame parent, final ConfirmSave confirmSave, final boolean doExit) {
        this((Component)parent, new GUICloser(){

            @Override
            public void closeGUI() {
                if (doExit) {
                    parent.dispose();
                }
            }

            @Override
            public boolean isStateChanged() {
                return confirmSave.isStateChanged();
            }

            @Override
            public void saveChanges() {
                confirmSave.saveChanges();
            }
        });
    }

    public static boolean checkForSave(JFrame parent, ConfirmSave confirmSave) {
        if (confirmSave.isStateChanged()) {
            int r = new ConfirmDialogBuilder(SAVE_CHANGES_MESSAGE).setTitle(STATE_CHANGED_MESSAGE).setNoOption(NO_MESSAGE).setYesOption(YES_MESSAGE).setCancleOption(CANCEL_MESSAGE).show(parent);
            if (r == 0 || r == 1) {
                if (r == 0) {
                    confirmSave.saveChanges();
                    return !confirmSave.isStateChanged();
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private ClosingWindowListener(Component parent, GUICloser guiCloser) {
        this.parent = parent;
        this.guiCloser = guiCloser;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.guiCloser.isStateChanged()) {
            int r = new ConfirmDialogBuilder(SAVE_CHANGES_MESSAGE).setTitle(CONFIRM_EXIT_MESSAGE).setNoOption(NO_MESSAGE).setYesOption(YES_MESSAGE).setCancleOption(CANCEL_MESSAGE).show(this.parent);
            if (r == 0 || r == 1) {
                if (r == 0) {
                    this.guiCloser.saveChanges();
                    if (!this.guiCloser.isStateChanged()) {
                        this.guiCloser.closeGUI();
                    }
                } else {
                    this.guiCloser.closeGUI();
                }
            }
        } else {
            this.guiCloser.closeGUI();
        }
    }

    public static interface ConfirmSave {
        public boolean isStateChanged();

        public void saveChanges();
    }

    public static interface GUICloser
    extends ConfirmSave {
        public void closeGUI();
    }
}

