/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.gui;

import de.neemann.gui.Screen;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.prefs.Preferences;

public final class WindowSizeStorage {
    private static final Preferences PREFS = Preferences.userRoot().node("dig").node("win");
    private static final String WIDTH_KEY = "width";
    private static final String HEIGHT_KEY = "height";
    private final Preferences prefs;
    private int defWidth = 1024;
    private int defHeight = 768;

    public WindowSizeStorage(String key) {
        this.prefs = PREFS.node(key);
    }

    public WindowSizeStorage setDefaultSize(int width, int height) {
        this.defWidth = width;
        this.defHeight = height;
        return this;
    }

    public void restore(final Component component) {
        int width = this.prefs.getInt(WIDTH_KEY, 0);
        int height = this.prefs.getInt(HEIGHT_KEY, 0);
        if (width < 100 || height < 80) {
            component.setSize(Screen.getInstance().scale(new Dimension(this.defWidth, this.defHeight)));
        } else {
            component.setSize(new Dimension(width, height));
        }
        component.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Dimension size = component.getSize();
                WindowSizeStorage.this.prefs.putInt(WindowSizeStorage.WIDTH_KEY, size.width);
                WindowSizeStorage.this.prefs.putInt(WindowSizeStorage.HEIGHT_KEY, size.height);
            }
        });
    }
}

